<?php echo tendoo_info( __( 'This display the actual stock of the material with all the unit on which it has been procured.', 'raw-material' ) );?>
<div class="row" id="material-stock">
    <div class="col-md-8">
        <div class="box">
            <div class="box-body no-padding">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <td><?php echo __( 'Unit', 'raw-material' );?></td>
                            <td class="text-right"><?php echo sprintf( __( 'Unit Value (%s)', 'raw-material' ), $baseUnit[ 'NAME' ] );?></td>
                            <td class="text-right"><?php echo __( 'Quantity', 'raw-material' );?></td>
                            <td class="text-right"><?php echo sprintf( __( 'Base Unit Value (%s)', 'raw-material' ), $baseUnit[ 'NAME' ] );?></td>
                            <td class="text-right"><?php echo __( 'Details', 'raw-material' );?></td>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $total_base_unit    =   0;
                        ?>
                        <?php foreach( $materialStock as $stock ):?>
                        <?php
                        $unit   =   collect( $units )->filter( function( $unit ) use ( $stock ) {
                            return $unit[ 'ID' ] === $stock[ 'REF_UNIT' ];
                        });

                        
                        $unit_value     =   0;
                        $unit_name      =   __( 'Unknown Unit', 'raw-material' );

                        if ( ! $unit->isEmpty() ) {
                            $unit_name          =   $unit->first()[ 'NAME' ];
                            $unit_value         =   ( $unit->first()[ 'UNIT_VALUE' ] * $stock[ 'QUANTITY' ] );
                            $total_base_unit    +=  floatval( $unit_value );
                        }
                        ?>
                        <tr>
                            <td><?php echo $unit_name;?></td>
                            <td class="text-right"><?php echo $unit->first()[ 'UNIT_VALUE' ];?></td>
                            <td class="text-right"><?php echo $stock[ 'QUANTITY' ];?></td>
                            <td class="text-right"><?php echo $unit_value;?></td>
                            <td class="text-right">
                                <!-- Split button -->
                                <div class="btn-group">
                                    <button type="button" class="btn btn-danger dropdown-toggle btn-xs" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        <?php echo __( 'Options', 'raw-material' );?>
                                        <span class="caret"></span>
                                    </button>
                                    <ul class="dropdown-menu">
                                        <li><a href="<?php echo site_url([ 'dashboard', store_slug(), 'raw-material', 'material-unit', $stock[ 'REF_MATERIAL' ], $stock[ 'REF_UNIT' ] ]);?>"><i class="fa fa-eye"></i> <?php echo __( 'Summary', 'raw-material' );?></a></li>
                                        <li><convert-material 
                                            _unit='<?php echo json_encode( $unit->first() );?>' 
                                            _baseUnit='<?php echo ( json_encode( $baseUnit ) );?>'
                                            _stock='<?php echo json_encode( $stock );?>'></convert-material></li>
                                    </ul>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach;?>
                        <tfoot>
                            <tr class="info">
                                <td><?php echo sprintf( __( 'Base Unit : %s', 'raw-material' ), $baseUnit[ 'NAME' ] );?></td>
                                <td class="text-right"><?php echo $baseUnit[ 'UNIT_VALUE' ];?></td>
                                <td class="text-right"><?php echo __( 'N/A', 'raw-material' );?></td>
                                <td class="text-right"><?php echo $total_base_unit;?></td>
                                <td class="text-right"></td>
                            </tr>
                        </tfoot>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<script>
"use strict";
const materialStock     =   {
    url: {
        submitTransformation    :   '<?php echo site_url([ 'api', 'raw-material', 'convert', store_get_param('?')]);?>'
    },
    textDomain: {
        convert: `<?php echo __( 'Convert', 'raw-material' );?>`,
        unitAssigned: `<?php echo __( 'Target Unit', 'raw-material' );?>`,
        convertingFrom: `<?php echo __( 'You\'re converting from <strong>{unit}</strong> which has <strong>{quantity}</strong> quantities available.', 'raw-material' );?>`,
        anErrorOccured: `<?php echo __( 'An error has occured.', 'raw-material' );?>`,
        convertUnits: `<?php echo __( 'Convert Unit', 'raw-material' );?>`,
        quantityExceedAvailable: `<?php echo __( 'The quantity you\'re attempting to convert exceed what is available on the current unit.', 'raw-material' );?>`,
        whichUnitToConvertInto: `<?php echo __( 'Select the unit on which you would like to convert into', 'raw-material' );?>`,
        conversionSuccessful: `<?php echo __( 'Operation Done', 'raw-material' );?>`,
        defineHowManyQuantity: `<?php echo __( 'Define how many quantity of the current unit should be converted into the target unit.', 'raw-material' );?>`,
        quantityToConvert: `<?php echo __( 'Quantity', 'raw-material' );?>`,
    },
    units: <?php echo json_encode( ( array ) @$units );?>,
    baseUnit: <?php echo json_encode( ( array ) @$baseUnit );?>,
    material: <?php echo json_encode( ( array ) @$currentMaterial );?>,
}
</script>
<script>
"use strict";
    Vue.component( 'convert-material', {
        data: () => ({
            foo: 'bar',
            ...materialStock
        }),
        computed: {
            unit() {
                return JSON.parse( this.$attrs._unit );
            }, 
            baseUnit() {
                return JSON.parse( this.$attrs._baseUnit );
            },
            stock() {
                return JSON.parse( this.$attrs._stock );
            }
        },
        methods: {
            submitTransformation( fields ) {
                if ( parseFloat( this.stock.QUANTITY ) < parseFloat( fields.quantity ) ) {
                    return NexoAPI.Toast()( this.textDomain.quantityExceedAvailable );
                }

                this.disableButtons();
                HttpRequest.post( this.url.submitTransformation, fields ).then( result => {
                    if ( result.data.status === 'success' ) {
                        swal({
                            icon: 'success',
                            timer: 3000,
                            title: this.textDomain.conversionSuccessful,
                            text: result.data.message
                        });
                    }
                    this.enabledButtons();
                }).catch( ({response}) => {
                    console.log( response );
                    swal({
                        type: 'error',
                        title: this.textDomain.anErrorOccured,
                        text: response.data.message
                    })
                    this.enabledButtons();
                })
            },
            disableButtons() {
                $( '.swal2-confirm' ).attr( 'disabled', 'disabled' );
                $( '.swal2-cancel' ).attr( 'disabled', 'disabled' );
            },
            enabledButtons() {
                $( '.swal2-confirm' ).removeAttr( 'disabled' );
                $( '.swal2-cancel' ).removeAttr( 'disabled' );
            },
            launchConvertPopup() {
                swal({
                    title: this.textDomain.convertUnits,
                    showCancelButton: true,
                    html: `<div id="form">
                        <p class="bg-info" style="padding: 10px 20px">${this.textDomain.convertingFrom
                                .replace( '{unit}', this.unit.NAME )
                                .replace( '{quantity}', this.stock.QUANTITY )}
                        </p>
                        <div class="form-group">
                            <label for="exampleInputPassword1">${this.textDomain.unitAssigned}</label>
                            <select class="form-control" name="target">
                                ${this.units.filter( unit => unit.ID !== this.unit.ID && unit.REF_UNIT_GROUP === this.unit.REF_UNIT_GROUP ).map( unit => {
                                    return `<option value="${unit.ID}">${unit.NAME}</option>`;
                                }).join( '' )}
                            </select>
                            <span id="helpBlock" class="help-block">${this.textDomain.whichUnitToConvertInto}</span>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputPassword1">${this.textDomain.quantityToConvert}</label>
                            <input type="number" name="quantity" class="form-control" id="exampleInputPassword1">
                            <input type="hidden" name="from" value="${this.unit.ID}" class="form-control" id="exampleInputPassword1">
                            <span id="helpBlock" class="help-block">${this.textDomain.defineHowManyQuantity}</span>
                        </div>
                    </div>`
                });

                setTimeout( () => {
                    $( '.swal2-buttonswrapper' ).html( $( '.swal2-buttonswrapper' ).html() );
                    $( '.swal2-confirm ' ).bind( 'click', () => this.submitTransformation({
                        target  :   $( '[name="target"]' ).val(),
                        quantity :  $( '[name="quantity"]').val(),
                        from :  $( '[name="from"]').val(),
                        material: this.material.ID
                    }) );
                    $( '.swal2-cancel' ).bind( 'click', () => swal.close() );
                })
            }
        },
        mounted() {
            console.log( this.$attrs );
        },
        template: `<a @click="launchConvertPopup()"><i class="fa fa-flask"></i> ${materialStock.textDomain.convert}</a>`
    })
    new Vue({ el: '#material-stock' });
</script>