<?php echo tendoo_info( __( 'This display the actual stock of the material with all the unit on which it has been procured.', 'raw-material' ) );?>
<div class="row" id="material-stock">
    <div class="col-md-8">
        <div class="box">
            <div class="box-body no-padding">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <td><?php echo __( 'Unit', 'raw-material' );?></td>
                            <td class="text-right"><?php echo sprintf( __( 'Unit Value (%s)', 'raw-material' ), $baseUnit[ 'NAME' ] );?></td>
                            <td class="text-right"><?php echo __( 'Quantity', 'raw-material' );?></td>
                            <td class="text-right"><?php echo sprintf( __( 'Base Unit Value (%s)', 'raw-material' ), $baseUnit[ 'NAME' ] );?></td>
                            <td class="text-right"><?php echo __( 'Details', 'raw-material' );?></td>
                        </tr>
                    </thead>
                    <tbody>
                        <tr v-for="stock of stockSorted">
                            <td>{{ getUnitName( stock ) }}</td>
                            <td class="text-right">{{ getUnitValue( stock ) }}</td>
                            <td class="text-right">{{ stock.QUANTITY }}</td>
                            <td class="text-right">{{ getUnitTotalValue( stock ) }}</td>
                            <td class="text-right">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-danger dropdown-toggle btn-xs" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        <?php echo __( 'Options', 'raw-material' );?>
                                        <span class="caret"></span>
                                    </button>
                                    <ul class="dropdown-menu">
                                        <li><a :href="getLink( stock )"><i class="fa fa-eye"></i> <?php echo __( 'Summary', 'raw-material' );?></a></li>
                                        <li v-if="stock.OUTGOING_CONVERSION === '0'"><a href="javascript:void(0)" @click="setOutgoingConversion( stock, 'allow' )"><i class="fa fa-exchange"></i> <?php echo __( 'Allow Outgoing Conversion', 'raw-material' );?></a></li>
                                        <li v-if="stock.OUTGOING_CONVERSION === '1'"><a href="javascript:void(0)" @click="setOutgoingConversion( stock, 'disallow' )"><i class="fa fa-exchange"></i> <?php echo __( 'Disallow Outgoing Conversion', 'raw-material' );?></a></li>
                                        <li v-if="stock.INCOMING_CONVERSION === '0'"><a href="javascript:void(0)" @click="setIncomingConversion( stock, 'allow' )"><i class="fa fa-exchange"></i> <?php echo __( 'Allow Incoming Conversion', 'raw-material' );?></a></li>
                                        <li v-if="stock.INCOMING_CONVERSION === '1'"><a href="javascript:void(0)" @click="setIncomingConversion( stock, 'disallow' )"><i class="fa fa-exchange"></i> <?php echo __( 'Disallow Incoming Conversion', 'raw-material' );?></a></li>
                                        <li><convert-material 
                                                :material="material"
                                                :stock="stock"
                                                :unit="getUnit( stock )"
                                                :baseUnit="baseUnit"></convert-material></li>
                                    </ul>
                                </div>
                            </td>
                        </tr>
                    </tbody>
                    <tfoot>
                        <tr class="info">
                            <td><?php echo sprintf( __( 'Base Unit : %s', 'raw-material' ), $baseUnit[ 'NAME' ] );?></td>
                            <td class="text-right">{{ baseUnit.UNIT_VALUE }}</td>
                            <td class="text-right"><?php echo __( 'N/A', 'raw-material' );?></td>
                            <td class="text-right">{{ totalBaseUnit }}</td>
                            <td class="text-right">
                                <button @click="refreshStock()" type="button" class="btn btn-primary dropdown-toggle btn-xs">
                                    <i class="fa fa-refresh"></i> 
                                    <?php echo __( 'Refresh', 'raw-material' );?>
                                </button>
                            </td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
</div>
<script>
"use strict";
const materialStock     =   {
    url: {
        submitTransformation    :   '<?php echo site_url([ 'api', 'raw-material', 'convert', store_get_param('?')]);?>',
        materialDetails         :   `<?php echo site_url([ 'dashboard', store_slug(), 'raw-material', 'material-unit', '{material_id}', '{unit_id}', store_get_param( '?' ) ]);?>`,
        outgoingConversion      :   `<?php echo site_url([ 'api', 'raw-material', 'outgoing-conversion', store_get_param( '?' ) ]);?>`,
        incomingConversion      :   `<?php echo site_url([ 'api', 'raw-material', 'incoming-conversion', store_get_param( '?' ) ]);?>`,
        refreshStock            :   `<?php echo site_url([ 'api', 'raw-material', 'material-stock', '{id}', store_get_param( '?' )]);?>`,
    },
    textDomain: {
        convert: `<?php echo __( 'Convert', 'raw-material' );?>`,
        unitAssigned: `<?php echo __( 'Target Unit', 'raw-material' );?>`,
        chooseAValue: `<?php echo __( '-- Choose --', 'raw-material' );?>`,
        convertingFrom: `<?php echo __( 'You\'re converting from <strong>{unit}</strong> which has <strong>{quantity}</strong> quantities available.', 'raw-material' );?>`,
        anErrorOccured: `<?php echo __( 'An error has occured.', 'raw-material' );?>`,
        convertUnits: `<?php echo __( 'Converting : {material_name}', 'raw-material' );?>`,
        chooseADestination: `<?php echo __( 'Choose a destination unit.', 'raw-material' );?>`,
        defineAQuantity: `<?php echo __( 'Define a quantity.', 'raw-material' );?>`,
        quantityExceedAvailable: `<?php echo __( 'The quantity you\'re attempting to convert exceed what is available on the current unit.', 'raw-material' );?>`,
        possibleQuantity: `<?php echo __( 'Possible', 'raw-material' );?>`,
        whichUnitToConvertInto: `<?php echo __( 'Select the unit on which you would like to convert into', 'raw-material' );?>`,
        conversionSuccessful: `<?php echo __( 'Operation Done', 'raw-material' );?>`,
        defineHowManyQuantity: `<?php echo __( 'Define how many quantity of the current unit should be converted into the target unit.', 'raw-material' );?>`,
        quantityToConvert: `<?php echo __( 'Quantity', 'raw-material' );?>`,
        anUnexpectedErrorOccured: `<?php echo __( 'An unexpected error has occured.', 'raw-material' );?>`,
        conversionStatusUpdated: `<?php echo __( 'The conversion status has been updated.', 'raw-material' );?>`,
    },
    units: <?php echo json_encode( ( array ) @$units );?>,
    baseUnit: <?php echo json_encode( ( array ) @$baseUnit );?>,
    material: <?php echo json_encode( ( array ) @$currentMaterial );?>,
    stocks: <?php echo json_encode( ( array ) @$materialStock );?>,
}
</script>
<script src="<?php echo module_url( 'raw-material' ) . 'js/material-stock.vue.js';?>"></script>