<?php
namespace RawMaterial\Inc;

use Tendoo_Module;
use RawMaterial\Classes\Material;
use Modules;

class Actions extends Tendoo_Module
{
    public function __construct()
    {
        parent::__construct();
        $this->setup        =   new Setup;
        $this->material     =   new Material;
    }

    public function enable_module( $namespace )
    {
        if ( $namespace === 'raw-material' ) {
            $this->load->model( 'Nexo_Stores' );

            $stores         =   $this->Nexo_Stores->get();

            array_unshift( $stores, [
                'ID'        =>  0
            ]);

            foreach( $stores as $store ) {
                $store_prefix       =   $store[ 'ID' ] == 0 ? '' : 'store_' . $store[ 'ID' ] . '_';
                $this->setup->install( $this->db->dbprefix . $store_prefix );
            }
        }
    }

    public function enable_material()
    {
        Modules::enable( 'raw-material' );
    }

    public function load_dashboard()
    {
        $this->events->add_action( 'paginating_' . store_prefix() . 'gastro_materials_usage_summary', [ $this, 'paginating_material_unit' ], 10, 2 );
    }

    public function check_tables()
    {
        if ( 
            ! $this->db->table_exists( store_prefix() . 'gastro_materials_units' ) || 
            ! $this->db->table_exists( store_prefix() . 'gastro_materials_units_groups' ) || 
            ! $this->db->table_exists( store_prefix() . 'gastro_materials' ) || 
            ! $this->db->table_exists( store_prefix() . 'gastro_materials_units_stock' ) || 
            ! $this->db->table_exists( store_prefix() . 'gastro_materials_recipes_summary' ) || 
            ! $this->db->table_exists( store_prefix() . 'gastro_materials_usage' ) || 
            ! $this->db->table_exists( store_prefix() . 'gastro_materials_usage_summary' ) || 
            ! $this->db->table_exists( store_prefix() . 'gastro_materials_recipes' ) || 
            ! $this->db->table_exists( store_prefix() . 'gastro_materials_recipes_items' ) || 
            ! $this->db->table_exists( store_prefix() . 'gastro_materials_supplies' ) || 
            ! $this->db->table_exists( store_prefix() . 'gastro_materials_supplies_items' )
        ) {
            $this->notice->push_notice( 
                tendoo_info( 
                    sprintf( 
                        __( 'The raw material is not installed on this store. <a href="%s">Click here to install it</a>.', 'raw-material' ), 
                        site_url([ 'dashboard', store_slug(), 'raw-material', 'install?ref=' . urlencode( current_url() )]) 
                    )
                ) 
            );
        }
    }

    /**
     * register a recipe field
     * that should be saved on the items
     * @return void
     */
    public function register_recipe_field()
    {
        $fields     =   $this->config->item( 'nexo_item_stock_group' );
        $fields[]   =   'REF_RECIPE';
        $fields[]   =   'OVERRIDE_STOCK';
        $this->config->set_item( 'nexo_item_stock_group', $fields );
    }

    public function load_pos_footer()
    {
        $this->load->module_view( 'raw-material', 'registers.pos' );
    }

    /**
     * @param Object ActiveRecordObject
     * @param array config
     */
    public function paginating_material_unit( $query, $config )
    {
        /**
         * expecting
         * @param int material_id
         * @param int unit_id
         */
        extract( $config );

        $query->where( 'REF_MATERIAL', $material_id )
            ->where( 'REF_UNIT', $unit_id );
    }

    /**
     * Consume a material using the provided
     * order product id, data and item data
     * @param int product id
     * @param array post data
     * @param array item data
     * @return void
     */
    public function consume_material( $order_product_id, $item_data, $order, $item )
    {
        if ( $this->events->apply_filters_ref_array( 'raw_material_deplete_override', [ false, $order_product_id, $item_data, $order, $item ]) === false ) {
            $recipe_id  =   $item[ 'REF_RECIPE' ];
            $material   =   new Material;
            $result     =   $material->depleteMaterialsFromRecipe( $recipe_id, floatval( $item[ 'QTE_ADDED' ] ), $item[ 'ID' ], $order_product_id );
        }
    }

    public function nexo_empty_shop()
    {
        ( new Material )->reset( true );        
    }

    public function delete_store( $store_id, $store, $prefix )
    {
        ( new Setup )->uninstall( $this->db->dbprefix . $prefix );
    }

    public function install_tables( $table_prefix, $scope, $short_prefix )
    {
        ( new Setup )->install( $table_prefix );
    }

    public function preconsume_material( $data )
    {
        $this->load->module_model( 'nexo', 'Nexo_Orders_Model', 'nexo_order_model' );
        $this->load->module_model( 'nexo', 'NexoItems', 'item_model' );

        extract( $data );
        /**
         * @param array foods
         * @param array state
         * @param array order_code
         * @param array all_foods
         */
        $order      =   $this->nexo_order_model->getOrderOnly( $order_code, 'CODE' );
        
        if ( $state === 'in_preparation' && ! empty( $order ) ) {
            foreach( $foods as $food_id ) {
                $item_data      =   $this->db->where( 'ID', $food_id )
                    ->get( store_prefix() . 'nexo_commandes_produits' )
                    ->result_array();    
                    
                $realItem       =   $this->item_model->getUsingBarcodeAndSku( $item_data[0][ 'REF_PRODUCT_CODEBAR' ] );

                if ( $this->events->apply_filters_ref_array( 'raw_material_override_materials_depletion', [ false ]) === false ) {
                    $this->consume_material( $food_id, $item_data[0], $order, [
                        'QTE_ADDED'     =>  $item_data[0][ 'QUANTITE' ],
                        'ID'            =>  $realItem[ 'ID' ],
                        'REF_RECIPE'    =>  $realItem[ 'REF_RECIPE' ]
                    ]);
                }
            }
        }
    }

    public function check_stock( $data )
    {
        $this->load->module_model( 'nexo', 'Nexo_Orders_Model', 'nexo_order_model' );
        $this->load->module_model( 'nexo', 'NexoItems', 'item_model' );

        extract( $data );
        /**
         * @param array foods
         * @param array state
         * @param array order_code
         * @param array all_foods
         */
        $order      =   $this->nexo_order_model->getOrderOnly( $order_code, 'CODE' );
        
        if ( $state === 'in_preparation' && ! empty( $order ) ) {
            
            $flyStock   =   [];
            $result     =   [];

            foreach( $foods as $food_id ) {
                $item_data      =   $this->db->where( 'ID', $food_id )
                    ->get( store_prefix() . 'nexo_commandes_produits' )
                    ->result_array();    
                    
                if ( isset( $realItem[ 'REF_RECIPE' ] ) ) {
                    $realItem   =   $this->item_model->getUsingBarcodeAndSku( $item_data[0][ 'REF_PRODUCT_CODEBAR' ] );
                    $response   =   $this->material->canConsumeRecipe( $realItem[ 'REF_RECIPE' ], $item_data[0][ 'QUANTITE' ], $flyStock );
                    $result[]   =   $response;
                    $flyStock   =   $response[ 'data' ][ 'flyStock' ];
                }
            }

            $hasError   =   collect( $result )->filter( function( $result ) {
                if ( $result[ 'status' ] === 'failed' ) {
                    return true;
                }
                return false;
            })->count() > 0;

            if ( $hasError ) {
                http_response_code( 403 );
                echo json_encode([
                    'status'    =>  'failed',
                    'message'   =>  __( 'Unable to proceed an error has occured. Likely one of the ingredient is no more sufficient.', 'raw-material' ),
                    'data'      =>  $result
                ]);
                die;
            }
        }
    }
}