Vue.component( 'convert-material', {
    data: () => ({
        foo: 'bar',
        ...materialStock
    }),
    props: [ 'unit', 'baseunit', 'stock', 'material' ],
    methods: {
        submitTransformation( fields ) {
            if ( parseFloat( this.stock.QUANTITY ) < parseFloat( fields.quantity ) ) {
                return NexoAPI.Toast()( this.textDomain.quantityExceedAvailable );
            }

            if ( $('[name="target"]').val().length === 0 ) {
                return NexoAPI.Toast()( this.textDomain.chooseADestination );
            }

            if ( $('[name="quantity"]').val().length === 0 ) {
                return NexoAPI.Toast()( this.textDomain.defineAQuantity );
            }

            this.disableButtons();
            HttpRequest.post( this.url.submitTransformation, fields ).then( result => {
                if ( result.data.status === 'success' ) {
                    swal({
                        icon: 'success',
                        timer: 3000,
                        title: this.textDomain.conversionSuccessful,
                        text: result.data.message
                    });
                    MaterialStockVue.refreshStock();
                }
                this.enabledButtons();
            }).catch( ({response}) => {
                console.log( response );
                swal({
                    type: 'error',
                    title: this.textDomain.anErrorOccured,
                    text: response.data.message
                })
                this.enabledButtons();
            })
        },
        disableButtons() {
            $( '.swal2-confirm' ).attr( 'disabled', 'disabled' );
            $( '.swal2-cancel' ).attr( 'disabled', 'disabled' );
        },
        enabledButtons() {
            $( '.swal2-confirm' ).removeAttr( 'disabled' );
            $( '.swal2-cancel' ).removeAttr( 'disabled' );
        },
        launchConvertPopup() {
            swal({
                title: this.textDomain.convertUnits.replace( '{material_name}', this.material.NAME ),
                showCancelButton: true,
                html: `<div id="form">
                    <p class="bg-info" style="padding: 10px 20px">${this.textDomain.convertingFrom
                            .replace( '{unit}', this.unit.NAME )
                            .replace( '{quantity}', this.stock.QUANTITY )}
                    </p>
                    <div class="form-group">
                        <label for="exampleInputPassword1">${this.textDomain.unitAssigned}</label>
                        <div class="input-group">
                            <span class="input-group-addon" id="basic-addon1">${this.textDomain.possibleQuantity} : <span id="possible">0</span></span>
                            <select class="form-control" name="target">
                                <option value="">${this.textDomain.chooseAValue}</option>
                                ${this.units.filter( unit => unit.ID !== this.unit.ID && unit.REF_UNIT_GROUP === this.unit.REF_UNIT_GROUP ).map( unit => {
                                    return `<option value="${unit.ID}">${unit.NAME} - (${unit.UNIT_VALUE})</option>`;
                                }).join( '' )}
                            </select>
                        </div>
                        <span id="helpBlock" class="help-block">${this.textDomain.whichUnitToConvertInto}</span>
                    </div>
                    <div class="form-group">
                        <label for="exampleInputPassword1">${this.textDomain.quantityToConvert}</label>
                        <div class="input-group">
                            <input type="number" name="quantity" class="form-control" id="exampleInputPassword1">
                            <span style="color:green" class="input-group-addon" id="basic-addon1"><span id="final"></span></span>
                        </div>
                        <span id="helpBlock" class="help-block">${this.textDomain.defineHowManyQuantity}</span>
                    </div>
                    <input type="hidden" name="from" value="${this.unit.ID}" class="form-control" id="exampleInputPassword1">
                </div>`
            });

            setTimeout( () => {
                $( '.swal2-buttonswrapper' ).html( $( '.swal2-buttonswrapper' ).html() );
                $( '[name="quantity"]' ).bind( 'blur', function() {
                    if ( $( this ).val().length > 0 ) {
                        $( this ).val( parseInt( $( this ).val() ) );
                    }
                });
                $( '[name="target"]' ).change( () => {
                    const unit      =   MaterialStockVue.getUnit({ REF_UNIT : $( '[name="target"]' ).val() });

                    if ( unit !== false ) {
                        const possible  =   parseFloat( this.stock.QUANTITY ) * parseFloat( this.unit.UNIT_VALUE ) / parseFloat( unit.UNIT_VALUE );
                        $( '#possible' ).html( possible );
                        this.refreshFinalQuantity( unit );
                    }
                });
                $( '[name="quantity"]' ).keyup( () => {
                    const unit      =   MaterialStockVue.getUnit({ REF_UNIT : $( '[name="target"]' ).val() });
                    if ( unit !== false ) {
                        this.refreshFinalQuantity( unit );
                    }
                });
                $( '.swal2-confirm ' ).bind( 'click', () => {
                    this.submitTransformation({
                        target      :   $( '[name="target"]' ).val(),
                        quantity    :   $( '[name="quantity"]').val(),
                        from        :   $( '[name="from"]').val(),
                        material    :   this.material.ID
                    });
                });
                $( '.swal2-cancel' ).bind( 'click', () => swal.close() );
            }, 100 )
        },

        refreshFinalQuantity( unit ) {
            const finalQuantity     =   ( parseFloat( this.unit.UNIT_VALUE ) * parseFloat( $( '[name="quantity"]' ).val() ) ) / parseFloat( unit.UNIT_VALUE );
            $( '#final' ).html( `+${ finalQuantity || 0 }` );
        }
    },
    mounted() {
        console.log( this.$attrs );
    },
    template: `<a @click="launchConvertPopup()"><i class="fa fa-flask"></i> ${materialStock.textDomain.convert}</a>`
})
const MaterialStockVue  =   new Vue({ 
    el: '#material-stock',
    data: {
        ...materialStock
    },
    computed: {
        totalBaseUnit() {
            if ( this.stocks.length > 0 ) {
                return this.stocks
                    .filter( stock => {
                        const unit  =   this.getUnit( stock );
                        return unit.REF_UNIT_GROUP === this.baseUnit.REF_UNIT_GROUP;
                    })
                    .map( ( stock ) => {
                    return parseFloat( stock.QUANTITY ) * this.getUnitValue( stock );
                }).reduce( ( b, a ) => b + a );
            } else {
                return 0;
            }
        },
        stockSorted() {
            const copy  =   this.stocks
                .filter( stock => {
                    const unit  =   this.getUnit( stock );
                    return unit.REF_UNIT_GROUP === this.baseUnit.REF_UNIT_GROUP;
                })
                .map( v => v );
            copy.sort( ( before, after ) => {

                const beforeUnit    =   this.getUnit( before );
                const afterUnit     =   this.getUnit( after );
                const val1          =   parseFloat( beforeUnit.UNIT_VALUE );
                const val2          =   parseFloat( afterUnit.UNIT_VALUE );
                
                return val1 < val2 ? -1 :
                val2 > val1 ? 1 : 
                0
            });
            console.log( copy );
            return copy;
        }
    },
    methods: {
        getUnitName( stock ) {
            return this.getUnit( stock ).NAME;
        },
        getUnitValue( stock ) {
            return parseFloat( this.getUnit( stock ).UNIT_VALUE );
        },
        getUnit( stock ) {
            return this.units.filter( _unit => _unit.ID === stock.REF_UNIT )[0] || false;
        },
        getUnitTotalValue( stock ) {
            return parseFloat( this.getUnit( stock ).UNIT_VALUE ) * parseFloat( stock.QUANTITY );
        },
        getBaseUnit( stock ) {

        },
        getLink( stock ) {
            return this.url.materialDetails
                .replace( '{material_id}', stock.REF_MATERIAL )
                .replace( '{unit_id}', stock.REF_UNIT );
        },
        refreshStock() {
            HttpRequest.get( this.url.refreshStock.replace( '{id}', this.material.ID ) ).then( result => {
                this.stocks     =   result.data;
            }, ({ response }) => {
                NexoAPI.Toast()( response.data.message || response.message || this.textDomain.anUnexpectedErrorOccured );
            });
        },
        setOutgoingConversion( stock, status ) {
            HttpRequest.post( this.url.outgoingConversion, { stock, status }).then( result => {
                if ( status === 'allow' ) {
                    stock.OUTGOING_CONVERSION = '1';
                } else {
                    stock.OUTGOING_CONVERSION = '0';
                }
                NexoAPI.Toast()( this.textDomain.conversionStatusUpdated );
            });
        },
        setIncomingConversion( stock, status ) {
            HttpRequest.post( this.url.incomingConversion, { stock, status }).then( result => {
                if ( status === 'allow' ) {
                    stock.INCOMING_CONVERSION = '1';
                } else {
                    stock.INCOMING_CONVERSION = '0';
                }
                NexoAPI.Toast()( this.textDomain.conversionStatusUpdated );
            });
        },
    }
});