<?php
namespace RawMaterial\Api;

use User;
use Tendoo_Api;
use RawMaterial\Classes\Material;

class MainController extends Tendoo_Api
{
    public function saveRecipe()
    {
        $material   =   new Material;
        $result     =   $material->saveRecipe(
            $this->post( 'name' ),
            $this->post( 'ingredients' ),
            ( string ) $this->post( 'description' )
        );
        return $this->response( $result );
    }

    public function updateRecipe( $id )
    {
        $material   =   new Material;

        /**
         * update and create new ingredient
         */
        foreach( $this->put( 'ingredients' ) as $ingredient ) {
            if ( isset( $ingredient[ 'id' ] ) ) {
                $material->updateIngredient( $ingredient[ 'id' ], $ingredient );
            } else {
                $material->addIngredient( $id, $ingredient );
            }
        }

        $material->updateRecipe( $id, $this->put( 'name' ), $this->put( 'description' ) );

        /**
         * delete ingredients
         */
        if ( $this->put( 'deleted' ) !== NULL && count( $this->put( 'deleted' ) ) > 0 ) {
            foreach( $this->put( 'deleted' ) as $id ) {
                $material->removeIngredient( $id );
            }
        }

        $rawMaterial        =   $material->getRecipe( $id );

        return $this->response([
            'status'    =>  'success',
            'message'   =>  __( 'The recipe has been correctly updated', 'raw-material' ),
            'data'      =>  compact( 'rawMaterial' )
        ]);
    }

    public function saveProcurement()
    {
        $material   =   new Material;

        $items              =   $this->post( 'entries' );
        $title              =   $this->post( 'title' );
        $refProcurement     =   $this->post( 'ref_id' );

        if ( empty( $refProcurement ) ) {
            $response   =   $material->createAndSupplyProcurement( $title, $items );
            return $this->response([
                'status'    =>  $response[ 'status' ],
                'message'   =>  $response[ 'status' ] === 'success' ? __( 'The procurement has been created', 'raw-material' ) : $response[ 'message' ]
            ]);            
        } else {
            $response   =   $material->addMaterialUnitToProcurement( $refProcurement, $items );
            return $this->response([
                'status'    =>  $response[ 'status' ],
                'message'   =>  $response[ 'status' ] === 'success' ? __( 'The procurement has been updated', 'raw-material' ) : $response[ 'message' ]
            ]);  
        }
    }

    public function defaults()
    {
        ( new Material )->reset( $this->post( 'clearAll' ) );

        return $this->response([
            'status'    =>  'success',
            'message'   =>  __( 'The default has been created', 'raw-material' ),
        ]);
    }

    public function getMaterialUnits( $material_id )
    {   
        $materialService    =   new Material;
        $material           =   $materialService->getMaterial( $material_id );
        $group              =   $materialService->getUnitGroup( $material[ 'REF_UNIT_GROUP' ] );

        foreach( $group[ 'units' ] as &$unit ) {
            $unit[ 'stock' ]      =   $materialService->getMaterialUnitStock( $material_id, $unit[ 'ID' ] );
        }

        return $this->response( $group );
    }

    public function convert()
    {
        $material   =   new Material;
        $response   =   $material->convertUnitFrom( 
            $this->post( 'from' ), 
            $this->post( 'target' ), 
            $this->post( 'quantity' ),
            $this->post( 'material' )
        );

        return $this->response( $response, $response[ 'status' ] === 'failed' ? 403 : 200 );
    }

    public function getMaterialStock( $id )
    {
        $material           =   new Material;
        $materialStock      =   $material->getMaterialStock( $id );

        return $this->response( $materialStock );
    }

    public function materialReport()
    {
        $startDate          =   $this->post( 'startDate' );
        $endDate            =   $this->post( 'endDate' );

        $material           =   new Material;
        $result             =   $material->getMaterialsSummary( $startDate, $endDate );
        return $this->response( $result );
    }

    public function getRecipesReport()
    {
        $startDate          =   $this->post( 'startDate' );
        $endDate            =   $this->post( 'endDate' );

        $material           =   new Material;
        $result             =   $material->getRecipeSummary( $startDate, $endDate );
        return $this->response( $result );
    }

    public function outgoingConversion()
    {
        $stock      =   $this->post( 'stock' );
        $status     =   $this->post( 'status' );

        $material   =   new Material;
        $result     =   $material->defineConversionStatus( 'outgoing', $stock[ 'ID' ], $status );
        $this->response( $result );
    }

    public function incomingConversion()
    {
        $stock      =   $this->post( 'stock' );
        $status     =   $this->post( 'status' );

        $material   =   new Material;
        $result     =   $material->defineConversionStatus( 'incoming', $stock[ 'ID' ], $status );
        $this->response( $result );
    }

    public function defineUnitStock()
    {
        $materialUtility    =   new Material;
        $materials          =   $materialUtility->getMaterials();
        
        collect( $materials )->each( function( $material ) use ( $materialUtility ) {
            $units          =   $materialUtility->getUnitsFromGroup( $material[ 'REF_UNIT_GROUP' ] );
            collect( $units )->each( function( $unit ) use ( $material, $materialUtility ) {
                $existing   =   $materialUtility->getMaterialUnitStock( $material[ 'ID' ], $unit[ 'ID' ] );

                if ( $existing === false ) {
                    $this->db->insert( store_prefix() . 'gastro_materials_units_stock', [
                        'INCOMING_CONVERSION'   =>  0,
                        'OUTGOING_CONVERSION'   =>  0,
                        'QUANTITY'              =>  0,
                        'REF_UNIT'              =>  $unit[ 'ID' ],
                        'REF_MATERIAL'          =>  $material[ 'ID' ],
                        'AUTHOR'                =>  User::id(),
                        'DATE_CREATION'         =>  date_now(),
                    ]);
                }
            });
        });

        $this->response([
            'status'    =>  'success',
            'message'   =>  __( 'The material units has been defined.', 'raw-material' )
        ]);
    }

    /**
     * Adjust raw material
     * units
     */
    public function adjustement()
    {
        $materialService    =   new Material;
        $material_id        =   ( int ) $this->post( 'material_id' );
        $unit_id            =   ( int ) $this->post( 'unit_id' );
        $value              =   ( int ) $this->post( 'value' );

        if ( $this->post( 'action_type' ) === 'deduct' ) {
            $response   =   $materialService->decreaseStockUnit( $material_id, $unit_id, $value );
        } else {
            $response   =   $materialService->increaseStockUnit( $material_id, $unit_id, $value );
        }

        $materialService->trackStockAdjustment( 
            $material_id, 
            $unit_id, 
            $value, 
            $this->post( 'action_type' ), 
            $this->post( 'description' )
        );

        return $this->response( $response );
    }
}
