<div id="report-items">
    <div class="box">
        <div class="no-padding">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th><?php echo __( 'Product', 'raw-material' );?></th>
                        <th><?php echo __( 'UOM', 'raw-material' );?></th>
                        <th class="text-right"><?php echo __( 'Unit Price', 'raw-material' );?></th>
                        <th class="text-right"><?php echo __( 'Quantity', 'raw-material' );?></th>
                        <th class="text-right"><?php echo __( 'Total Price', 'raw-material' );?></th>
                    </tr>
                </thead>
                <tbody>
                    <tr v-for="item of supply.items">
                        <td scope="row">{{ getMaterialName( item.REF_MATERIAL ) }}</td>
                        <td>{{ getUnitName( item.REF_UNIT ) }}</td>
                        <td class="text-right">{{ item.PURCHASE_PRICE | moneyFormat }}</td>
                        <td class="text-right">{{ item.QUANTITY }}</td>
                        <td class="text-right">{{ item.TOTAL_PRICE | moneyFormat }}</td>
                    </tr>
                </tbody>
                <tfoot>
                    <tr>
                        <td colspan="4"></td>
                        <td class="text-right">{{ total | moneyFormat }}</td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>
<script>
"use strict";
const ProcurementData   =   {
    units: <?php echo json_encode( $units );?>,
    supply: <?php echo json_encode( $supply );?>,
    materials: <?php echo json_encode( $materials );?>,
    textDomain: {
        undefined: `<?php echo __( 'Undefined', 'raw-material' );?>`
    }
}
</script>
<script>
"use strict";
$( document ).ready( () => {
    const report    =   new Vue({
        el: '#report-items',
        data: {
        ...ProcurementData 
        },
        mounted() {
            
        }, 
        computed: {
            total() {
                return this.supply.items
                    .map( item => parseFloat( item.TOTAL_PRICE ) )
                    .reduce( ( before, after ) => before + after );
            }
        },
        methods: {
            getUnitName( id ) {
                const unit  =   this.units.filter( material => material.ID === id );

                if ( unit.length > 0 ) {
                    return unit[0].NAME;
                }

                return this.textDomain.undefined;
            }, 
            getMaterialName( id ) {
                const item  =   this.materials.filter( material => material.ID === id );

                if ( item.length > 0 ) {
                    return item[0].NAME;
                }

                return this.textDomain.undefined;
            }
        }
    })
});
</script>