<script>
"use strict";
const rawMateriaPosTextDomain   =   {
    unableToProceed: `<?php echo __( 'Unable to proceed', 'raw-material' );?>`,
    entryError: `<?php echo __( 'The item <strong>{item}</strong> cannot be cooked as there is not enough ingredients for the material <strong>{material}</strong> for the unit <strong>{unit}</strong>', 'raw-material' );?>`
}
</script>

<script>
"use strict";
NexoAPI.events.addFilter( 'pos_error_response', ( error ) => {
    const textDomain    =   rawMateriaPosTextDomain;
    const response      =   error.response.data;

    if ( response.by === 'raw-material' ) {
        console.log( response.data );
        swal({
            title: textDomain.unableToProceed,
            html: `
            <ul class="list-group">
                ${response.data.filter( entry => entry.depletion.status === 'failed' )
                    .map( _error => {
                        return _error.depletion.data.result.filter( e => e.status === 'failed' ).map( entry => {
                            return `<li class="list-group-item">${
                                textDomain.entryError.replace( '{item}', _error.item.DESIGN )
                                    .replace( '{material}', entry.data.material.NAME )
                                    .replace( '{unit}', entry.data.unit.NAME )
                            }</li>`
                        }).join( '' );
                    }).join( '' )}
            </ul>
            `
        })
        return false;
    }
    return error;
});
</script>