<div class="row">
    <div class="col-md-6">
        <div class="box">
            <div class="box-body no-padding">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <td ><?php echo __( 'Status', 'raw-material' );?></td>
                            <td class="text-right"><?php echo __( 'Quantity', 'raw-material' );?></td>
                            <td class="text-right"><?php echo __( 'Unit', 'raw-material' );?></td>
                            <td class="text-right"><?php echo __( 'Recipe', 'raw-material' );?></td>
                            <td class="text-right"><?php echo __( 'Author', 'raw-material' );?></td>
                            <td class="text-right"><?php echo __( 'Date', 'raw-material' );?></td>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach( $history[ 'entries' ] as $entry ):?>
                        <?php
                        $user   =   collect( $users )->filter( function( $user ) use ( $entry ) {
                            return floatval( $entry->AUTHOR ) === floatval( $user->user_id );
                        })->first();

                        switch( $entry->STATUS ) {
                            case 'procurement':
                                $status = __( 'Procurement', 'raw-material' );
                            break;
                            case 'deletion': 
                                $status = __( 'Deletion', 'raw-material' );
                            break;
                            case 'consumption':
                                $status = __( 'Consumption', 'raw-material' );
                            break;
                            case 'convert-in':
                                $status = __( 'Converted In', 'raw-material' );
                            break;
                            case 'convert-out':
                                $status = __( 'Converted Out', 'raw-material' );
                            break;
                            default:
                                $status = __( 'N/A', 'raw-material' );
                            break;
                        }
                        ?>
                        <tr class="<?php echo $entry->STATUS === 'deletion' ? 'danger' : ( $entry->STATUS === 'consumption' ? 'success' : ( $entry->STATUS === 'procurement' ? 'info' : '' ) );?>">
                            <td ><?php echo $status;?></td>
                            <td class="text-right"><?php echo $entry->QUANTITY;?></td>
                            <td class="text-right"><?php echo $unit[ 'NAME' ];?></td>
                            <td class="text-right">
                                <?php if ( @$entry->recipe[ 'NAME' ] !== null ):?>
                                    <a href="<?php echo site_url([ 'dashboard', store_slug(), 'raw-material', 'recipes', 'edit', $entry->recipe[ 'ID' ] ]);?>">
                                        <?php echo @$entry->recipe[ 'NAME' ] ?? __( 'N/A', 'raw-material' );?>
                                    </a>
                                <?php else: ?>
                                    <?php echo __( 'N/A', 'raw-material' );?>
                                <?php endif;?>
                            </td>
                            <td class="text-right"><?php echo @$user->user_name ?? __( 'N/A', 'raw-material' );?></td>
                            <td class="text-right"><?php echo nexo_date_format( $entry->DATE_CREATION );?></td>
                        </tr>
                        <?php endforeach;?>
                        <?php if ( ! $history[ 'entries' ] ):?>
                        <tr>
                            <td colspan="6"><?php echo __( 'There is not entry to display', 'raw-material' );?></td>
                        </tr>
                        <?php endif;?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>