<?php
use App\Classes\Hook;
use App\Classes\Output;
?>


<?php $__env->startSection( 'layout.dashboard.body' ); ?>
<div class="h-full flex flex-col flex-auto">
    <?php echo $__env->make( Hook::filter( 'ns-dashboard-header-file', '../common/dashboard-header' ) , \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="px-4 flex-auto flex flex-col" id="dashboard-content">
        <?php echo $__env->make( 'common.dashboard.title' , \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <ns-crud-form 
            return-url="<?php echo e($returnUrl); ?>"
            submit-method="<?php echo e($submitMethod ?? 'POST'); ?>"
            :option-attributes='<?php echo json_encode( $optionAttributes ?? [] , 15, 512) ?>'
            :query-params='<?php echo json_encode( $queryParams ?? [] , 15, 512) ?>'
            submit-url="<?php echo e($submitUrl); ?>"
            src="<?php echo e($src); ?>">
            <template v-slot:title><?php echo e($mainFieldLabel ?? __( 'mainFieldLabel not defined' )); ?></template>
            <template v-slot:save><?php echo e($saveButton ?? __( 'Save' )); ?></template>
            <template v-slot:error-required><?php echo e($fieldRequired ?? __( 'This field is required' )); ?></template>
            <template v-slot:error-invalid><?php echo e($formNotValid ?? __( 'The form is not valid. Please check it and try again' )); ?></template>
        </ns-crud-form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection( 'layout.dashboard.footer' ); ?>
    <?php echo \Illuminate\View\Factory::parentPlaceholder('layout.dashboard.footer'); ?>
    <?php
    $output     =   new Output;
    Hook::action( 'ns-crud-form-footer', $output, $namespace )
    ?>
    <?php echo ( string ) $output; ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make( 'layout.dashboard' , \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gposarytech/public_html/resources/views/pages/dashboard/crud/form.blade.php ENDPATH**/ ?>