<?php
use App\Models\Order;
use App\Classes\Hook;
use Illuminate\Support\Facades\View;
// dd($order->toArray());
function calculateDemoSaveGold($total, $type) {
    $gold_fraction = 0;
    $coin_fraction = 0;
    $excessAmount = 0;
    
    if ($total == 25000) {
        $gold_fraction = 0.8;
        $coin_fraction = 0;
    }
    if ($total > 25000) {
        $gold_fraction = 0;
        $coin_fraction = 0.5;
    }

    $result = 0;
    if ($type == "gold") {
        if ($total > 25000) {
            $result = 20000;
        } else {
            $result = $total * $gold_fraction;
        }
    } else if ($type == "coin") {
        if ($total > 25000) {
            $excessAmount = $total - 25000;
            $result = $excessAmount * $coin_fraction;
        } else {
            $result = $total * $coin_fraction;
        }
    }

    return round($result, 2);
}

?>
<div class="receipt-max-w w-full mx-auto receipt-p-0">
    <div class="receipt-bg-white text-black border-b border-t border-dashed border-black">
        <div class="flex flex-col items-center justify-center">
            <?php if( empty( ns()->option->get( 'ns_invoice_receipt_logo' ) ) ): ?>
                <h3 class="receipt-text-xs font-bold text-black"><?php echo e(ns()->option->get( 'ns_store_name' )); ?></h3>
            <?php else: ?>
                <img src="<?php echo e(ns()->option->get( 'ns_invoice_receipt_logo' )); ?>" style="height:150px" alt="<?php echo e(ns()->option->get( 'ns_store_name' )); ?>">
                <h3 class="receipt-text-xs font-bold text-black"><?php echo e(ns()->option->get( 'ns_store_name' )); ?></h3>
            <?php endif; ?>
        </div>
        <div class="receipt-p-2 border-b border-black">
            <div class="flex flex-wrap -mx-2 receipt-text-xs text-black">
                <div class="px-2 w-1/2">
                    <?php echo nl2br( $ordersService->orderTemplateMapping( 'ns_invoice_receipt_column_a', $order ) ); ?>

                </div>
                <div class="px-2 w-1/2">
                    <?php echo nl2br( $ordersService->orderTemplateMapping( 'ns_invoice_receipt_column_b', $order ) ); ?>

                </div>
            </div>
        </div>
        <div class="table w-full">
            <table class="w-full">
                <thead>
                    <tr class="font-semibold receipt-text-xs text-black">
                        <td class="receipt-p-2"><?php echo e(__( 'Product' )); ?></td>
                        <td class="receipt-p-2 text-center"><?php echo e(__( 'Qty.' )); ?></td>
                        <td class="receipt-p-2 text-right"><?php echo e(__( 'Total' )); ?></td>
                    </tr>
                </thead>
                <tbody class="receipt-text-xs border-b border-black text-black">
                    <?php $__currentLoopData = Hook::filter( 'ns-receipt-products', $order->combinedProducts ); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="receipt-p-2"><?php echo e($product->name); ?></td>
                        <td class="receipt-p-2 text-center"><?php echo e($product->quantity); ?></td>
                        <td class="receipt-p-2 text-right"><?php echo e(ns()->currency->define( $product->total_price )); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
                <tbody>
                    <tr>
                        <td colspan="2" class="receipt-p-2 receipt-text-xs font-semibold text-black"><?php echo e(__( 'Sub Total' )); ?></td>
                        <td class="receipt-p-2 receipt-text-xs text-right text-black"><?php echo e(ns()->currency->define( $order->subtotal )); ?></td>
                    </tr>
                    <?php if( $order->discount > 0 ): ?>
                    <tr>
                        <td colspan="2" class="receipt-p-2 receipt-text-xs font-semibold text-black">
                            <span><?php echo e(__( 'Discount' )); ?></span>
                            <?php if( $order->discount_type === 'percentage' ): ?>
                            <span>(<?php echo e($order->discount_percentage); ?>%)</span>
                            <?php endif; ?>
                        </td>
                        <td class="receipt-p-2 receipt-text-xs text-right text-black"><?php echo e(ns()->currency->define( $order->discount )); ?></td>
                    </tr>
                    <?php endif; ?>
                    <?php if( $order->total_coupons > 0 ): ?>
                    <tr>
                        <td colspan="2" class="receipt-p-2 receipt-text-xs font-semibold text-black"><?php echo e(__( 'Coupons' )); ?></td>
                        <td class="receipt-p-2 receipt-text-xs text-right text-black"><?php echo e(ns()->currency->define( $order->total_coupons )); ?></td>
                    </tr>
                    <?php endif; ?>
                    <?php if( ns()->option->get( 'ns_invoice_display_tax_breakdown' ) === 'yes' ): ?> 
                        <?php $__currentLoopData = $order->taxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td colspan="2" class="receipt-p-2 receipt-text-xs font-semibold text-black">
                                <span><?php echo e($tax->tax_name); ?> &mdash; <?php echo e($order->tax_type === 'inclusive' ? __( 'Inclusive' ) : __( 'Exclusive' )); ?></span>
                            </td>
                            <td class="receipt-p-2 receipt-text-xs text-right text-black"><?php echo e(ns()->currency->define( $tax->tax_value )); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php if( $order->products_tax_value > 0 ): ?>
                        <tr>
                            <td colspan="2" class="receipt-p-2 receipt-text-xs font-semibold text-black"><?php echo e($order->tax_type === 'inclusive' ? __( 'Inclusive Product Taxes' ) : __( 'Exclusive Product Taxes' )); ?></td>
                            <td class="receipt-p-2 receipt-text-xs text-right text-black"><?php echo e(ns()->currency->define( $order->products_tax_value )); ?></td>
                        </tr>
                        <?php endif; ?>
                    <?php else: ?>                     
                        <?php if( $order->tax_value > 0 ): ?>
                        <tr>
                            <td colspan="2" class="receipt-p-2 receipt-text-xs font-semibold text-black"><?php echo e(__( 'Taxes' )); ?></td>
                            <td class="receipt-p-2 receipt-text-xs text-right text-black"><?php echo e(ns()->currency->define( $order->tax_value )); ?></td>
                        </tr>
                        <?php elseif( $order->products_tax_value > 0 ): ?>
                        <tr>
                            <td colspan="2" class="receipt-p-2 receipt-text-xs font-semibold text-black"><?php echo e($order->tax_type === 'inclusive' ? __( 'Inclusive Product Taxes' ) : __( 'Exclusive Product Taxes' )); ?></td>
                            <td class="receipt-p-2 receipt-text-xs text-right text-black"><?php echo e(ns()->currency->define( $order->products_tax_value )); ?></td>
                        </tr>
                        <?php endif; ?>
                    <?php endif; ?>
                    <?php if( $order->shipping > 0 ): ?>
                    <tr>
                        <td colspan="2" class="receipt-p-2 receipt-text-xs font-semibold text-black"><?php echo e(__( 'Shipping' )); ?></td>
                        <td class="receipt-p-2 receipt-text-xs text-right text-black"><?php echo e(ns()->currency->define( $order->shipping )); ?></td>
                    </tr>
                    <?php endif; ?>
                    <tr>
                        <td colspan="2" class="receipt-p-2 receipt-text-xs font-semibold text-black"><?php echo e(__( 'Total' )); ?></td>
                        <td class="receipt-p-2 receipt-text-xs text-right text-black"><?php echo e(ns()->currency->define( $order->total )); ?></td>
                    </tr>
                    <?php $__currentLoopData = $order->payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="receipt-p-2 receipt-text-xs font-semibold text-black" colspan="2"><?php echo e($paymentTypes[ $payment[ 'identifier' ] ] ?? __( 'Unknown Payment' )); ?></td>
                        <td class="receipt-p-2 receipt-text-xs text-right text-black"><?php echo e(ns()->currency->define( $payment[ 'value' ] )); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td colspan="2" class="receipt-p-2 receipt-text-xs font-semibold text-black"><?php echo e(__( 'Paid' )); ?></td>
                        <td class="receipt-p-2 receipt-text-xs text-right text-black"><?php echo e(ns()->currency->define( $order->tendered )); ?></td>
                    </tr>
                    <?php if( in_array( $order->payment_status, [ 'refunded', 'partially_refunded' ]) ): ?>
                        <?php $__currentLoopData = $order->refund; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $refund): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td colspan="2" class="receipt-p-2 receipt-text-xs font-semibold text-black"><?php echo e(__( 'Refunded' )); ?></td>
                            <td class="receipt-p-2 receipt-text-xs text-right text-black"><?php echo e(ns()->currency->define( - $refund->total )); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                    <?php switch( $order->payment_status ):
                        case ( Order::PAYMENT_PAID ): ?>
                        <tr>
                            <td colspan="2" class="receipt-p-2 receipt-text-xs font-semibold text-black"><?php echo e(__( 'Change' )); ?></td>
                            <td class="receipt-p-2 receipt-text-xs text-right text-black"><?php echo e(ns()->currency->define( $order->change )); ?></td>
                        </tr>
                        <?php break; ?>
                        <?php case ( Order::PAYMENT_PARTIALLY ): ?>
                        <tr>
                            <td colspan="2" class="receipt-p-2 receipt-text-xs font-semibold text-black"><?php echo e(__( 'Due' )); ?></td>
                            <td class="receipt-p-2 receipt-text-xs text-right text-black"><?php echo e(ns()->currency->define( abs( $order->change ) )); ?></td>
                        </tr>
                        <?php break; ?>
                    <?php endswitch; ?>
                    <tr class="border-t border-dashed border-black">
                            <td colspan="2" class="receipt-p-2 receipt-text-xs font-semibold text-black"><?php echo e(__( 'Save Gold' )); ?></td>
                            <td class="receipt-p-2 receipt-text-xs text-right text-black"><?php echo e(calculateDemoSaveGold($order->total, 'gold')); ?> mg</td>
                        </tr>
                        <tr>
                            <td colspan="2" class="receipt-p-2 receipt-text-xs font-semibold text-black"><?php echo e(__( 'Cold Coin' )); ?></td>
                            <td class="receipt-p-2 receipt-text-xs text-right text-black"><?php echo e(calculateDemoSaveGold($order->total, 'coin')); ?></td>
                        </tr>
                </tbody>
            </table>
            <?php if( $order->note_visibility === 'visible' ): ?>
            <div class="receipt-pt-6 receipt-pb-4 text-center receipt-text-xs text-black">
                <strong><?php echo e(__( 'Note: ' )); ?></strong> <?php echo e($order->note); ?>

            </div>
            <?php endif; ?>
            <div class="receipt-pt-6 receipt-pb-4 text-center receipt-text-xs text-black">
                <?php echo e(ns()->option->get( 'ns_invoice_receipt_footer' )); ?>

            </div>
        </div>
    </div>
</div>
<?php echo $__env->renderWhen( request()->query( 'autoprint' ) === 'true', '/pages/dashboard/orders/templates/_autoprint' , \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path'])); ?>

<style>
@media print {
    .receipt-max-w {
        max-width: 210px !important; /* Adjust this to fit your thermal paper width */
    }
    .receipt-p-0 {
        padding: 0 !important;
    }
    .receipt-bg-white {
        background-color: white !important;
    }
    .receipt-text-xs {
        font-size: 10px !important; /* Adjust as necessary for your print layout */
    }
    .receipt-p-2 {
        padding: 2px !important; /* Adjust as necessary for your print layout */
    }
    .receipt-pt-6 {
        padding-top: 6px !important; /* Adjust as necessary for your print layout */
    }
    .receipt-pb-4 {
        padding-bottom: 4px !important; /* Adjust as necessary for your print layout */
    }
    /* Set overall text color to black */
    body {
        color: black !important;
    }
}
</style>
<?php /**PATH /home/gposarytech/public_html/resources/views/pages/dashboard/orders/templates/_receipt.blade.php ENDPATH**/ ?>