<?php $__env->startSection('layout.dashboard.body'); ?>
<div class="h-full flex-auto flex flex-col">
    <?php echo $__env->make(Hook::filter('ns-dashboard-header-file', '../common/dashboard-header'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="px-4 flex-auto flex flex-col" id="dashboard-content">
        <?php echo $__env->make('common.dashboard.title', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <ns-procurement-invoice></ns-procurement-invoice>
    </div>
</div>
<script type="text/x-template" id="ns-procurement-invoice">
<div class="p-4 shadow ns-box">
    <div id="printable-container">

        <div class="my-1 flex items-center justify-between">
            <div>
                <img class="w-32" src="<?php echo e(ns()->option->get('ns_store_rectangle_logo')); ?>" alt="<?php echo e(ns()->option->get('ns_store_name')); ?>">
            </div>
            <div class="text-gray-600">
                <!-- <?php echo e(sprintf(__('Purchase Order : %s'), $procurement->name)); ?> -->
                <?php echo e($procurement->name); ?>

            </div>
            <div class="text-gray-600">
                <?php echo e(sprintf(__('Date : %s'), $procurement->updated_at)); ?>

            </div>
        </div>
        <div class="flex flex-wrap -mx-3 text-primary">
            <div class="px-3 w-full print:w-1/3 md:w-1/3">
                <h3 class="font-semibold text-xl border-b-2 border-blue-400 py-2 mb-2"><?php echo e(__('Provider')); ?></h3>
                <ul>
                    <li class="py-1"><span class="font-bold"><?php echo e(__('Name')); ?>: </span> <?php echo e($procurement->provider->first_name); ?></li>
                    <!-- <li class="py-1"><span class="font-bold"><?php echo e(__('Last Name')); ?>: </span><?php echo e($procurement->provider->last_name ?? __('N/A')); ?></li> -->
                    <li class="py-1"><span class="font-bold"><?php echo e(__('Email')); ?>: </span><?php echo e($procurement->provider->email ?? __('N/A')); ?></li>
                    <li class="py-1"><span class="font-bold"><?php echo e(__('Phone')); ?>: </span><?php echo e($procurement->provider->phone ?? __('N/A')); ?></li>
                    <li class="py-1"><span class="font-bold"><?php echo e(__('Address')); ?>: </span><?php echo e($procurement->provider->address_1 ?? __('N/A')); ?></li>
                    <!-- <li class="py-1"><span class="font-bold"><?php echo e(__('Second Address')); ?>: </span><?php echo e($procurement->provider->address_2 ?? __('N/A')); ?></li> -->
                </ul>
            </div>
            <div class="px-3 w-full print:w-1/3 md:w-1/3">
                <h3 class="font-semibold text-xl border-b-2 border-blue-400 py-2 mb-2">Store</h3>
                <ul>
                    <li class="py-1"><span class="font-bold"><?php echo e(__('Name')); ?>: </span> <?php echo e($options->get('ns_store_name')); ?></li>
                    <li class="py-1"><span class="font-bold"><?php echo e(__('Address')); ?>: </span><?php echo e($options->get('ns_store_address') ?? __('N/A')); ?></li>
                    <li class="py-1"><span class="font-bold"><?php echo e(__('City')); ?>: </span><?php echo e($options->get('ns_store_city') ?? __('N/A')); ?></li>
                    <li class="py-1"><span class="font-bold"><?php echo e(__('Phone')); ?>: </span><?php echo e($options->get('ns_store_phone') ?? __('N/A')); ?></li>
                    <li class="py-1"><span class="font-bold"><?php echo e(__('Email')); ?>: </span><?php echo e($options->get('ns_store_email') ?? __('N/A')); ?></li>
                    <!-- <li class="py-1"><span class="font-bold"><?php echo e(__('PO.Box')); ?>: </span><?php echo e($options->get('ns_store_pobox') ?? __('N/A')); ?></li> -->
                </ul>
            </div>
            <div class="px-3 w-full print:w-1/3 md:w-1/3">
                <h3 class="font-semibold text-xl border-b-2 border-blue-400 py-2 mb-2">Purchase Order</h3>
                <ul>
                    <li class="py-1"><span class="font-bold"><?php echo e(__('Name')); ?>: </span> <?php echo e($procurement->name); ?></li>
                    <li class="py-1"><span class="font-bold"><?php echo e(__('Invoice Date')); ?>: </span> <?php echo e($procurement->invoice_date); ?></li>
                    <li class="py-1"><span class="font-bold"><?php echo e(__('Payment Mode')); ?>: </span><?php echo e(__($procurement->payment_mode)); ?></li>
                    <li class="py-1"><span class="font-bold"><?php echo e(__('Payment Term')); ?>: </span><?php echo e(__('Payment Term ' . $procurement->payment_term)); ?></li>
                    <li class="py-1"><span class="font-bold"><?php echo e(__('Store Location')); ?>: </span><?php echo e(__($procurement->location)); ?></li>
                    <li class="py-1 w-[300px]"><span class="font-bold"><?php echo e(__('Description')); ?>: </span><span class="line-clamp-3"><?php echo e($procurement->description); ?></span></li>
                    <li class="py-1"><span class="font-bold"><?php echo e(__('Purchase Order Issued by')); ?>: </span><?php echo e(__($procurement->full_name)); ?></li>
                    
                    
                </ul>
            </div>
        </div>
        <div class="my-4">
            <table class="ns-table">
                <thead class="border">
                    <tr>
                        <th><?php echo e(__('#')); ?></th>
                        <th><?php echo e(__('Product')); ?></th>
                        <!-- <th><?php echo e(__('Unit')); ?></th> -->
                        <th><?php echo e(__('Barcode')); ?></th>
                        <th><?php echo e(__('Unit')); ?></th>
                        <th><?php echo e(__('Unit Price')); ?></th>
                        <th><?php echo e(__('Gross Price')); ?></th>
                        <th><?php echo e(__('Quantity')); ?></th>
                        <th><?php echo e(__('FoC Quantity')); ?></th>
                        <th><?php echo e(__('Discount')); ?></th>
                        <th><?php echo e(__('Discount Extra')); ?></th>
                        <th><?php echo e(__('Total')); ?></th>
                    </tr>
                </thead>
                <tbody class="border">
                    <?php $__currentLoopData = $procurement->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                        <td class="text-right border p-1"><?php echo e($loop->iteration); ?></td>
                            <td class="border p-1">
                                <h3 class="font-semibold"><?php echo e($product->name); ?></h3>
                                <!-- <p class="text-xs"><?php echo e($product->remarks); ?></p> -->
                            </td>
                            <!-- <td class="border p-1"><?php echo e($product->unit->name); ?></td> -->
                            <td class="text-right border p-1"><?php echo e($product->barcode); ?></td>
                            <td class="text-right border p-1"><?php echo e($product->unit->name); ?>(s)</td>
                            <td class="text-right border p-1"><?php echo e((string) ns()->currency->define($product->purchase_price)); ?></td>
                            <td class="text-right border p-1"><?php echo e((string) ns()->currency->define($product->gross_purchase_price)); ?></td>
                            <td class="text-right border p-1"><?php echo e($product->quantity); ?></td>
                            <td class="text-right border p-1"><?php echo e($product->foc_quantity); ?></td>
                            <td class="text-right border p-1"><?php echo e($product->discount); ?>%</td>
                            <td class="text-right border p-1"><?php echo e($product->discount_extra); ?>%</td>
                            <td class="text-right border p-1"><?php echo e((string) ns()->currency->define($product->total_purchase_price)); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
                <tfoot class="border">
                    <tr>
                        <td :colspan="10" class="border p-1 font-bold"><?php echo e(__('Total')); ?></td>
                        <td class="text-right border p-1"><?php echo e(ns()->currency->define(
    $procurement->products->map(fn($product) => $product->total_purchase_price)->sum()
)); ?></td>
                    </tr>
                    <!-- <tr>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td class="border p-1"><?php echo e(__('Delivery Status')); ?></td>
                        <td class="text-right border p-1"><?php echo e(ns()->procurement->getDeliveryLabel($procurement->delivery_status)); ?></td>
                    </tr>
                    <tr>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td class="border p-1"><?php echo e(__('Payment Status')); ?></td>
                        <td class="text-right border p-1"><?php echo e(ns()->procurement->getPaymentLabel($procurement->payment_status)); ?></td>
                    </tr> -->
                </tfoot>
            </table>
        </div>
    </div>
    <div class="flex justify-between">
        <div></div>
        <div>
            <ns-button @click="printInvoice()" type="info">
                <i class="las la-print"></i>
                <?php echo e(__('Print')); ?>

            </ns-button>
        </div>
    </div>
</div>
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gposarytech/public_html/resources/views/pages/dashboard/procurements/purchase_orders/invoice.blade.php ENDPATH**/ ?>