"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.applyFiltersAsync = exports.applyFilters = exports.addFilter = exports.addAction = exports.actions = void 0;
Object.defineProperty(exports, "createHooks", {
  enumerable: true,
  get: function () {
    return _createHooks.default;
  }
});
exports.removeFilter = exports.removeAllFilters = exports.removeAllActions = exports.removeAction = exports.hasFilter = exports.hasAction = exports.filters = exports.doingFilter = exports.doingAction = exports.doActionAsync = exports.doAction = exports.didFilter = exports.didAction = exports.defaultHooks = exports.currentFilter = exports.currentAction = void 0;
var _createHooks = _interopRequireDefault(require("./createHooks"));
/**
 * Internal dependencies
 */

/** @typedef {(...args: any[])=>any} Callback */

/**
 * @typedef Handler
 * @property {Callback} callback  The callback
 * @property {string}   namespace The namespace
 * @property {number}   priority  The namespace
 */

/**
 * @typedef Hook
 * @property {Handler[]} handlers Array of handlers
 * @property {number}    runs     Run counter
 */

/**
 * @typedef Current
 * @property {string} name         Hook name
 * @property {number} currentIndex The index
 */

/**
 * @typedef {Record<string, Hook> & {__current: Set<Current>}} Store
 */

/**
 * @typedef {'actions' | 'filters'} StoreKey
 */

/**
 * @typedef {import('./createHooks').Hooks} Hooks
 */

const defaultHooks = exports.defaultHooks = (0, _createHooks.default)();
const {
  addAction,
  addFilter,
  removeAction,
  removeFilter,
  hasAction,
  hasFilter,
  removeAllActions,
  removeAllFilters,
  doAction,
  doActionAsync,
  applyFilters,
  applyFiltersAsync,
  currentAction,
  currentFilter,
  doingAction,
  doingFilter,
  didAction,
  didFilter,
  actions,
  filters
} = defaultHooks;
exports.filters = filters;
exports.actions = actions;
exports.didFilter = didFilter;
exports.didAction = didAction;
exports.doingFilter = doingFilter;
exports.doingAction = doingAction;
exports.currentFilter = currentFilter;
exports.currentAction = currentAction;
exports.applyFiltersAsync = applyFiltersAsync;
exports.applyFilters = applyFilters;
exports.doActionAsync = doActionAsync;
exports.doAction = doAction;
exports.removeAllFilters = removeAllFilters;
exports.removeAllActions = removeAllActions;
exports.hasFilter = hasFilter;
exports.hasAction = hasAction;
exports.removeFilter = removeFilter;
exports.removeAction = removeAction;
exports.addFilter = addFilter;
exports.addAction = addAction;
//# sourceMappingURL=index.js.map