"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.aliasesMap = exports.aliases = exports.defaults = exports.properties = void 0;
function properties(schema) {
    return schema.properties || {};
}
exports.properties = properties;
function defaults(schema) {
    let result = {};
    let props = properties(schema);
    Object.keys(props).forEach((key) => {
        let val = props[key];
        if (typeof val === 'object' && undefined !== val.default) {
            if (Array.isArray(val.default)) {
                result[key] = [...val.default];
            }
            else if (typeof val.default === 'object') {
                result[key] = Object.assign({}, val.default);
            }
            else {
                result[key] = val.default;
            }
        }
    });
    return result;
}
exports.defaults = defaults;
function aliases(schema) {
    let result = {};
    let props = properties(schema);
    Object.keys(props).forEach((key) => {
        let val = props[key];
        if (typeof val === 'object') {
            let title = val.title;
            if (title) {
                result[title] = result[title] || [];
                result[title].push(key);
            }
        }
    });
    return Object.values(result)
        .filter((keys) => keys.length > 1)
        .map((keys) => keys.sort().sort((a, b) => {
        if (a.length === b.length) {
            return 0;
        }
        return a.length > b.length ? 1 : -1;
    }));
}
exports.aliases = aliases;
function aliasesMap(schema) {
    let result = new Map();
    for (let row of aliases(schema)) {
        let [key, ...values] = row.reverse();
        for (let val of values) {
            result.set(val, key);
        }
    }
    return result;
}
exports.aliasesMap = aliasesMap;
