"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAliasProxy = exports.merge = void 0;
const schema_1 = require("../schema");
const schema = __importStar(require("./schema"));
const helper = __importStar(require("./helper"));
function merge(style, options) {
    let optionSources = [
        {
            seed: Math.random().toString(),
            /** @ts-ignore @deprecated - will be removed with version 5.0 */
            userAgent: typeof window !== 'undefined' && window.navigator && window.navigator.userAgent,
        },
        schema.defaults(schema_1.schema),
        schema.defaults(style.schema),
        options,
    ];
    let result = createAliasProxy(style);
    optionSources.forEach((optionSource) => {
        result = Object.assign(result, helper.omit(optionSource, '_aliases'));
    });
    return result;
}
exports.merge = merge;
function createAliasProxy(style) {
    let aliasMap = new Map([
        ...Array.from(schema.aliasesMap(schema_1.schema)),
        ...Array.from(schema.aliasesMap(style.schema)),
    ]);
    return new Proxy({
        _aliases: aliasMap,
    }, {
        get: (obj, key) => {
            var _a;
            let originalKey = ((_a = obj._aliases.get(key)) !== null && _a !== void 0 ? _a : key);
            return obj[originalKey];
        },
        set: (obj, key, value) => {
            var _a;
            let originalKey = ((_a = obj._aliases.get(key)) !== null && _a !== void 0 ? _a : key);
            obj[originalKey] = value;
            return true;
        },
        deleteProperty: (obj, key) => {
            var _a;
            let originalKey = ((_a = obj._aliases.get(key)) !== null && _a !== void 0 ? _a : key);
            delete obj[originalKey];
            return true;
        },
    });
}
exports.createAliasProxy = createAliasProxy;
