import type { Options } from '../options';
import type { Style, StyleCreateResult, StyleCreateResultAttributes } from '../types';
declare type CreateGroupProps = {
    children: string;
    x: number;
    y: number;
};
export declare function createGroup({ children, x, y }: CreateGroupProps): string;
export declare function getXmlnsAttributes(): {
    'xmlns:dc': string;
    'xmlns:cc': string;
    'xmlns:rdf': string;
    'xmlns:svg': string;
    xmlns: string;
};
export declare function getMetadata<O extends Options>(style: Style<O>): string;
export declare function getMetadataWorkTitle<O extends Options>(style: Style<O>): string;
export declare function getMetadataWorkCreator<O extends Options>(style: Style<O>): string;
export declare function getMetadataWorkSource<O extends Options>(style: Style<O>): string;
export declare function getMetadataWorkLicense<O extends Options>(style: Style<O>): string;
export declare function getMetadataWorkContributor<O extends Options>(style: Style<O>): string;
export declare function getMetadataWorkAgents(agents: string[]): string[];
export declare function getMetadataLicense<O extends Options>(style: Style<O>): string;
export declare function getViewBox(result: StyleCreateResult): {
    x: number;
    y: number;
    width: number;
    height: number;
};
/**
 * @deprecated use addScale instead
 */
export declare function addMargin<O extends Options>(result: StyleCreateResult, options: O | number): string;
/**
 * @deprecated use addViewboxMask instead
 */
export declare function addRadius<O extends Options>(result: StyleCreateResult, options: O): string;
export declare function addBackgroundColor<O extends Options>(result: StyleCreateResult, options: O | string): string;
export declare function addScale(result: StyleCreateResult, scale: number): string;
export declare function addTranslate(result: StyleCreateResult, x?: number, y?: number): string;
export declare function addRotate(result: StyleCreateResult, rotate: number): string;
export declare function addFlip(result: StyleCreateResult): string;
export declare function addViewboxMask(result: StyleCreateResult, radius: number): string;
export declare function createAttrString(attributes: StyleCreateResultAttributes): string;
export declare function removeWhitespace(svg: string): string;
export {};
