## Changes in current POS / Nexopos variant according to Shakeel bhai

Date:

# Module: Vendor/Provider/Supplier

## Field Table Representation

| **FieldLabel**                   | **FieldType** | **FieldKey**            | **Description**                                                                                      | **Status** |
| -------------------------------- | ------------- | ----------------------- | ---------------------------------------------------------------------------------------------------- | ---------- |
| **First Name**                   | text          | first_name              | Provide a name to the resource.                                                                      | existing   |
| **Supplier Active**              | text          | is_active               | Check if the supplier is active, unchecked means inactive (No).                                      | New        |
| **Email**                        | text          | email                   | Provide the provider email. Might be used to send automated email.                                   | existing   |
| **Last Name**                    | text          | last_name               | Provider last name if necessary.                                                                     | Removed    |
| **NIC Number**                   | text          | nic_number              | Provider’s National Identity Card number.                                                            | New        |
| **Phone**                        | text          | phone                   | Contact phone number for the provider. Might be used to send automated SMS notifications.            | existing   |
| **Description**                  | textarea      | description             | Description of the provider.                                                                         | Removed    |
| **Address 1**                    | text          | address_1               | First address of the provider.                                                                       | existing   |
| **Address 2**                    | text          | address_2               | Second address of the provider.                                                                      | existing   |
| **City**                         | text          | city                    | City of the provider.                                                                                | New        |
| **Postal Code**                  | number        | postal_code             | Postal code of the provider address.                                                                 | New        |
| **NTN No**                       | text          | ntn_no                  | NTN number of the provider.                                                                          | New        |
| **GST No**                       | text          | gst_no                  | G.S.T of the provider.                                                                               | New        |
| **Supplier Type**                | select        | supplier_type           | Select the type of supplier (e.g., Manufacturer, Distributor, Wholesaler, Retailer).                 | New        |
| **Bank Name**                    | text          | bank_name               | The name of the bank for the provider.                                                               | New        |
| **Account Number**               | text          | account_number          | The bank account number of the provider.                                                             | New        |
| **Payment Mode**                 | select        | payment_mode            | Select the payment mode for the provider (e.g., Advance, Credit, Cash on Delivery, Installments).    | New        |
| **Payment Term**                 | select        | payment_term            | Select the payment term for the provider (e.g., 30 Days, 60 Days, 90 Days, Upon Receipt).            | New        |
| **Balance Limit**                | number        | balance_limit           | Balance limit of the provider.                                                                       | New        |
| **WHT (Withholding Tax) Rate**   | number        | wht_rate                | The rate at which tax is withheld from payments made to the supplier, if applicable (e.g., 5%, 10%). | New        |
| **Excise Duty Rate**             | number        | excise_duty_rate        | Rate of excise duty imposed on the supplier’s products or services.                                  | New        |
| **Special Discount Rate**        | number        | special_discount_rate   | Any special discounts the supplier offers (e.g., for large volume orders, seasonal promotions).      | New        |
| **Regular Discount Rate**        | number        | regular_discount_rate   | Any regular discounts the supplier offers.                                                           | New        |
| **Primary Contact Name**         | text          | primary_contact_name    | Name of the primary contact person for the supplier.                                                 | New        |
| **Primary Contact Phone**        | text          | primary_contact_phone   | Phone number of the primary contact person.                                                          | New        |
| **Primary Contact Email**        | email         | primary_contact_email   | Email address of the primary contact person.                                                         | New        |
| **Primary Contact NIC Number**   | email         | primary_contact_nic     | National Identity Card number of the Primary contact person.                                         | New        |
| **Secondary Contact Name**       | text          | secondary_contact_name  | Name of the secondary contact person for the supplier.                                               | New        |
| **Secondary Contact Phone**      | text          | secondary_contact_phone | Phone number of the secondary contact person.                                                        | New        |
| **Secondary Contact Email**      | email         | secondary_contact_email | Email address of the secondary contact person.                                                       | New        |
| **Secondary Contact NIC Number** | email         | secondary_contact_nic   | National Identity Card number of the secondary contact person.                                       | New        |

# Module: Products/Items

## Field Table Representation

| **Field Label**              | **Field Type** | **Field Key**        | **Description**                                                          | **Status** |
| ---------------------------- | -------------- | -------------------- | ------------------------------------------------------------------------ | ---------- |
| **Name**                     | text           | name                 | Provide a name to the resource/product/item.                             | existing   |
| **Stock Management Enabled** | switch         | stock_management     | Enable stock management for products.                                    | new        |
| **Alias Name**               | text           | aliasName            | Provide a secondary or short name.                                       | existing   |
| **Category**                 | search-select  | category_id          | Select the category of the item.                                         | existing   |
| **Brand**                    | search-select  | brand_id             | Select the brand of the item.                                            | existing   |
| **Barcode**                  | text           | barcode              | Define the barcode value before scanning the product.                    | existing   |
| **SKU**                      | text           | sku                  | Define a unique SKU for the product.                                     | existing   |
| **Barcode Type**             | select         | barcode_type         | Define the barcode type scanned.                                         | existing   |
| **Product Type**             | select         | type                 | Define the product type. Applies to all variations.                      | existing   |
| **Vendors**                  | multiselect    | provider_ids         | Select multiple vendors related to this product.                         | new        |
| **Manufacturer**             | select         | manufacturer         | Select the manufacturer for the product.                                 | new        |
| **Status**                   | select         | status               | Define whether the product is available for sale.                        | existing   |
| **Description**              | textarea       | description          | Provide a description for the product.                                   | existing   |
| **Product Subitems**         | hidden         | product_subitems     | Sub-items associated with the product.                                   | existing   |
| **Unit Group**               | search-select  | unit_group           | Unit group applied during procurement.                                   | existing   |
| **Accurate Tracking**        | switch         | accurate_tracking    | The product won't be visible on the grid and fetched only using barcode. | delete     |
| **Auto COGS**                | switch         | auto_cogs            | The Cost of Goods Sold will be automatically computed.                   | delete     |
| **Assigned Unit**            | search-select  | unit_id              | The assigned unit for sale.                                              | existing   |
| **Convert Unit**             | select         | convert_unit_id      | The unit selected for conversion by default.                             | delete     |
| **Sale Price**               | number         | sale_price_edit      | Define the regular selling price.                                        | existing   |
| **Wholesale Price**          | number         | wholesale_price_edit | Define the wholesale price.                                              | existing   |
| **COGS**                     | number         | cogs                 | Used to define the Cost of Goods Sold.                                   | existing   |
| **Stock Alert**              | switch         | stock_alert_enabled  | Define whether stock alert should be enabled.                            | existing   |
| **Low Quantity**             | number         | low_quantity         | The quantity considered low.                                             | existing   |
| **Visible**                  | switch         | visible              | Define whether the unit is available for sale.                           | existing   |
| **Preview Url**              | media          | preview_url          | Provide a preview of the current unit.                                   | delete     |
| **Product Expires**          | switch         | expires              | Set to "No" if expiration time should be ignored.                        | existing   |
| **On Expiration**            | select         | on_expiration        | Define the action taken while a product has expired.                     | existing   |
| **Tax Group**                | select         | tax_group_id         | Select the tax group that applies to the product.                        | existing   |
| **Tax Type**                 | select         | tax_type             | Define the type of tax (Inclusive or Exclusive).                         | existing   |
| **Image**                    | media          | url                  | Choose an image for the product gallery.                                 | existing   |
| **Is Primary**               | switch         | featured             | Define if the image should be primary.                                   | existing   |

# Module: Brands

## Brand Form Fields

| **Field Label**  | **Field Type** | **Field Key**           | **Description**                                                         | **Status** |
| ---------------- | -------------- | ----------------------- | ----------------------------------------------------------------------- | ---------- |
| **Name**         | text           | name                    | Provide a name to the resource.                                         | existing   |
| **Active**       | switch         | active                  | Define whether the brand is active or not.                              | new        |
| **Report Title** | text           | report_name_placeholder | Provide a name that can be used for report names.                       | new        |
| **Email**        | text           | email                   | Provide the brand email, which might be used for automated emails.      | existing   |
| **Phone**        | text           | phone                   | Contact phone number for the brand, which might be used for SMS alerts. | existing   |
| **Address**      | text           | address                 | Address of the brand.                                                   | existing   |
| **Website**      | text           | website                 | Website of the brand.                                                   | existing   |

# Module: Category
