<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('nexopos_procurements_products', function (Blueprint $table) {
            $table->float('foc_quantity', 18, 5)->after('quantity');
            $table->float('discount', 18, 5)->default(0)->after('convert_unit_id');
            $table->float('discount_extra', 18, 5)->default(0)->after('discount');
            $table->string('barcode_type')->nullable()->after('barcode');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('nexopos_procurements_products', function (Blueprint $table) {
            $table->dropColumn('foc_quantity');
            $table->dropColumn('discount');
            $table->dropColumn('discount_extra');
            $table->dropColumn('barcode_type');
        });
    }
};
