<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('nexopos_procurements', function (Blueprint $table) {
            $table->string('procurement_type')->nullable()->after('name');
            $table->integer('procurement_parent_id')->nullable();
            $table->string('location')->nullable()->after('provider_id');
            $table->string('payment_term')->nullable()->after('location');
            $table->string('payment_mode')->nullable()->after('payment_term');
            $table->integer('updated_by')->nullable()->after('author');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('nexopos_procurements', function (Blueprint $table) {
            $table->dropColumn('procurement_type');
            $table->dropColumn('procurement_parent_id');
            $table->dropColumn('location');
            $table->dropColumn('payment_term');
            $table->dropColumn('payment_mode');
            $table->dropColumn('updated_by');
        });
    }
};
