<?php
/**
 * Table Migration
 **/

use App\Classes\Schema;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('nexopos_providers')) {
            Schema::createIfMissing('nexopos_providers', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->boolean('active')->default(false);
                $table->string('first_name');
                $table->string('last_name')->nullable();
                $table->string('email')
                    ->unique()
                    ->nullable();
                $table->string('city')->nullable();
                $table->string('phone')->nullable();
                $table->string('address_1')->nullable();
                $table->string('address_2')->nullable();
                $table->string('postal_code')->nullable();
                $table->string('ntn_no')->nullable();
                $table->string('gst_no')->nullable();
                $table->string('provider_category')->nullable();
                $table->string('provider_type')->nullable();
                $table->string('bank_name')->nullable();
                $table->string('account_number')->nullable();
                $table->string('payment_mode')->nullable();
                $table->string('payment_term')->nullable();
                $table->string('balance_limit')->nullable();
                $table->string('wht_rate')->nullable();
                $table->string('excise_duty_rate')->nullable();
                $table->string('special_discount_rate')->nullable();
                $table->string('regular_discount_rate')->nullable();
                $table->string('primary_contact_name')->nullable();
                $table->string('primary_contact_phone')->nullable();
                $table->string('primary_contact_email')->nullable();
                $table->string('primary_contact_nic')->nullable();
                $table->string('secondary_contact_name')->nullable();
                $table->string('secondary_contact_phone')->nullable();
                $table->string('secondary_contact_email')->nullable();
                $table->string('secondary_contact_nic')->nullable();
                $table->integer('author');
                $table->text('description')->nullable();
                $table->float('amount_due', 18, 5)->default(0);
                $table->float('amount_paid', 18, 5)->default(0);
                $table->string('uuid')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasTable('nexopos_providers')) {
            Schema::dropIfExists('nexopos_providers');
        }
    }
};
