<?php
/**
 * Table Migration
 **/

use App\Classes\Schema;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('nexopos_procurements_products')) {
            Schema::createIfMissing('nexopos_procurements_products', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('master_product_id')->nullable(); // Foreign key for the master product, will be filledi n grn
                $table->string('name');
                $table->float('gross_purchase_price', 18)->default(0);
                $table->float('net_purchase_price', 18)->default(0);
                $table->integer('procurement_id');
                $table->integer('product_id');
                $table->float('purchase_price', 18)->default(0);
                $table->float('quantity', 18);
                $table->float('new_quantity_received', 18)->default(0); //For future refrence of GRN's record
                $table->float('foc_quantity', 18);
                $table->float('available_quantity', 18);
                $table->integer('tax_group_id')->nullable();
                $table->string('barcode')->nullable();
                // $table->string('barcode_type')->nullable();
                // $table->string('condition')->nullable();
                $table->datetime('expiration_date')->nullable();
                $table->string('tax_type'); // inclusive or exclusive;
                $table->float('tax_value', 18)->default(0);
                $table->float('total_purchase_price', 18)->default(0);
                $table->integer('unit_id');
                $table->integer('convert_unit_id')->nullable();
                $table->float('discount', 18)->default(0);
                $table->float('discount_extra', 18)->default(0);
                $table->integer('author');
                $table->string('uuid')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasTable('nexopos_procurements_products')) {
            Schema::dropIfExists('nexopos_procurements_products');
        }
    }
};
