<?php

use App\Services\Helper;


return [
    'label' => __('Procurements'),
    'fields' => [
        [
            'name' => 'ns_pos_unit_mode',
            'value' => ns()->option->get('ns_pos_unit_mode'),
            'options' => Helper::kvToJsOptions([
                'simplified' => __('Simplified units'),
                'advanced' => __('Advanced units'),
            ]),
            'label' => __('POS Unit Mode'),
            'type' => 'select',
            'description' => __('Change the unit mode of the POS.'),
        ],
        //TODO: define these in model as const
        [
            'name' => 'ns_pos_procurement_flow',
            'value' => ns()->option->get('ns_pos_procurement_flow'),
            'options' => Helper::kvToJsOptions([
                'direct' => __('Direct Procurement'),
                'po_grn' => __('P.O and G.R.N Flow'),
            ]),
            'label' => __('Procurement Method'),
            'type' => 'select',
            'description' => __('Select the procurement method.'),
        ],
        [
            'name' => 'ns_pos_product_creation',
            'value' => ns()->option->get('ns_pos_product_creation'),
            'options' => Helper::kvToJsOptions([
                'simplified' => __('Simplified Product creation'),
                'advanced' => __('Advanced Product creation'),
            ]),
            'label' => __('Product Creation Mode'),
            'type' => 'select',
            'description' => __('Select the Product creation options.'),
        ],
    ],
];
