<?php

namespace App\Services;
use Cache;
use Carbon\Carbon;
use Exception;

class ARYSaveGoldService
{
    public function __construct(
        protected Options $optionsService
    ) {
        if ($this->optionsService->get('ns_ary_save_gold_enable') != 'yes') {
            throw new Exception(__('ARY Save Gold not enabled!'));
        }
    }
    public function ARYSaveGoldConnection()
    {
        return array(
            'tokenCall' => $this->getSaveGoldToken(),
            // 'search_customer' => $this->searchSaveGoldCustomer()
        );
    }

    protected function connection($reqParams, $__dataToEncrypt, $_url = null)
    {
        if (empty($_url)) {
            throw new Exception(__('URL is not passed!'));
        }
        if (empty($__dataToEncrypt)) {
            throw new Exception(__('__dataToEncrypt is not passed!'));
        }
        if (empty($reqParams)) {
            throw new Exception(__('reqParams is not passed!'));
        }
        try {
            $saveGoldOptions = array(
                'ns_ary_save_gold_merchant_id' => $this->optionsService->get('ns_ary_save_gold_merchant_id'),
                'ns_ary_save_gold_merchant_serial' => $this->optionsService->get('ns_ary_save_gold_merchant_serial'),
                'ns_ary_save_gold_user_name' => $this->optionsService->get('ns_ary_save_gold_user_name'),
                'ns_ary_save_gold_user_pass' => $this->optionsService->get('ns_ary_save_gold_user_pass'),
                'ns_ary_save_gold_shared_key' => $this->optionsService->get('ns_ary_save_gold_shared_key'),
                'ns_ary_save_gold_base_url' => $this->optionsService->get('ns_ary_save_gold_base_url')
            );
            $sharedKey = $saveGoldOptions['ns_ary_save_gold_shared_key'];
            $responseType = 2;
            $dataToEncrypt = $__dataToEncrypt;
            $jsonParameters = "{";
            foreach ($reqParams as $key => $value) {
                $jsonParameters .= '"' . $key . '":"' . ($saveGoldOptions[$value] ?? $value) . '",';
                // if ($key != 'TokenNo' || $key != 'TokenKey') {
                //     $dataToEncrypt .= $saveGoldOptions[$value] ?? $value;
                // }
            }
            $encrypted = base64_encode(hash_hmac("sha256", $dataToEncrypt, $sharedKey, true));
            $jsonParameters .= '
            "OutletCode":"' . $saveGoldOptions['ns_ary_save_gold_merchant_id'] . '",
            "ResponseType":"' . $responseType . '",
            "RegionID":"1",
            "EncryptedValue":"' . $encrypted . '",
            "RequestSource":"web",
            "requestTypeID":1
            }';
            // dd($jsonParameters);
            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => $saveGoldOptions['ns_ary_save_gold_base_url'] . $_url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => $jsonParameters,
                CURLOPT_HTTPHEADER => array(
                    'Content-Type: application/json',
                    'Content-Length: ' . strlen($jsonParameters)
                ),
            ));
            $response = curl_exec($curl);
            $response = json_decode($response);
            if (!$response->Status) {
                throw new Exception($response->ResponseMessage);
            }
            return json_decode($response->ResponseDescription);
        } catch (Exception $e) {
            // return $e->getMessage();
            throw new Exception('Network Error: ' . $e->getMessage());
        }
    }

    protected function getSaveGoldToken()
    {
        // Check if the token is already cached
        $cacheItem = Cache::get('saveGoldAPIToken');
        if (!$cacheItem) {
            try {
                $reqParams = array(
                    'UserName' => 'ns_ary_save_gold_user_name',
                    'Password' => 'ns_ary_save_gold_user_pass',
                );
                $unecryptedKey = $this->optionsService->get('ns_ary_save_gold_merchant_id') . $this->optionsService->get('ns_ary_save_gold_user_name') . $this->optionsService->get('ns_ary_save_gold_user_pass') . 2;
                $token = $this->connection($reqParams, $unecryptedKey, '/tokenrequest');

                // Save the token and the last saved time in cache
                Cache::put('saveGoldAPIToken', [
                    'token' => $token,
                    'saveGoldAPITokenLastSaved' => now(),
                ], now()->addMinutes(3)); // Store for 3 minutes

                return $token;
            } catch (Exception $e) {
                throw new Exception($e->getMessage());
            }
        }

        return $cacheItem['token']; // Return cached token
    }

    public function searchSaveGoldCustomer($cellNo = null)
    {
        if (is_null($cellNo) || strlen($cellNo) != 12) {
            throw new Exception("Cell No. Not provided");
        }
        $startTime = microtime(true);
        try {
            $token = $this->getSaveGoldToken();
            // $cellNo = '923331666981';
            $reqParams = array(
                'CellNo' => $cellNo,
                'TokenKey' => $token->TokenKey,
                'TokenNo' => $token->Token,
            );
            $unecryptedKey = $cellNo . $this->optionsService->get('ns_ary_save_gold_merchant_id') . 2 . 1;
            $customer = $this->connection($reqParams, $unecryptedKey, '/searchCustomer');
            return array('tokenData' => $token, 'searchData' => $customer, 'timeElapsed' => microtime(true) - $startTime);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    public function registerSaveGoldCustomer($cellNo, $fullName = 'ARY Tech POS Customer')
    {
        if (is_null($cellNo) || strlen($cellNo) != 12) {
            throw new Exception("Cell No. Not provided");
        }
        $startTime = microtime(true);
        try {
            $token = $this->getSaveGoldToken();
            // $cellNo = '923331666981';
            $reqParams = array(
                'CellNo' => $cellNo,
                'City' => 'Karachi',
                'Gender' => 'Male',
                'ProfessionID_FK' => 1,
                'CustomerName' => $fullName,
                'TokenKey' => $token->TokenKey,
                'TokenNo' => $token->Token,
            );
            $unecryptedKey = $this->optionsService->get('ns_ary_save_gold_merchant_id') . 2 . 1 . $cellNo . 'Karachi' . $fullName;
            // dd($unecryptedKey);
            $customer = $this->connection($reqParams, $unecryptedKey, '/CustomerRegistration');
            return array('tokenData' => $token, 'searchData' => $customer, 'timeElapsed' => microtime(true) - $startTime);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    public function createSaveGoldPurchase($cellNo, $orderId)
    {
        if (is_null($cellNo) || strlen($cellNo) != 12) {
            throw new Exception("Cell No. Not provided");
        }
        if (is_null($orderId)) {
            throw new Exception("Order ID Not provided");
        }
        $startTime = microtime(true);
        $productTypeCode = '001';
        try {
            $token = $this->getSaveGoldToken();
            // $cellNo = '923331666981';
            $reqParams = array(
                'CellNo' => $cellNo,
                'TransactionAmount' => 100,
                'TransactionID' => $orderId,
                'ProductTypeCode' => $productTypeCode,
                'TokenKey' => $token->TokenKey,
                'TokenNo' => $token->Token,
            );
            $unecryptedKey = $this->optionsService->get('ns_ary_save_gold_merchant_id') . 2 . 1 . $cellNo . $orderId . $productTypeCode;
            // dd($unecryptedKey);
            $customer = $this->connection($reqParams, $unecryptedKey, '/purchaserequest');
            return array('tokenData' => $token, 'searchData' => $customer, 'timeElapsed' => microtime(true) - $startTime);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    public function getCachedSaveGoldToken()
    {
        $cacheItem = Cache::get('saveGoldAPIToken');
        $timeRemaining = 0;
        $expirationTime = null;
        if (!is_null($cacheItem)) {
            $lastSaved = Carbon::parse($cacheItem['saveGoldAPITokenLastSaved']);
            $expirationTime = $lastSaved->addMinutes(3);
            $timeRemaining = now()->diffInMinutes($expirationTime, false);
        }

        return array('cachedToken' => $cacheItem, 'timeRemaining' => $timeRemaining, 'willExpireAt' => $expirationTime);
    }
    public function purgeCachedSaveGoldToken()
    {
        Cache::forget('saveGoldAPIToken');
        dd(Cache::get('saveGoldAPIToken'));
    }
    public function invalidateCachedSaveGoldToken()
    {
        $oldCached = $this->getCachedSaveGoldToken();
        if (!empty($oldCached['cachedToken'])) {
            $newCached = $oldCached;
            $newCached['cachedToken']['token']->Token = 'loool';
            Cache::put('saveGoldAPIToken', $newCached, $oldCached['cachedToken']['saveGoldAPITokenLastSaved']);
        }

        return array('old' => $oldCached, 'new' => $this->getCachedSaveGoldToken());
    }
}
