<?php

namespace App\Models;

use App\Traits\NsDependable;
use Illuminate\Database\Eloquent\Factories\HasFactory;

/**
 * @property int            $id
 * @property string         $uuid
 * @property int            $author
 * @property boolean        $active
 * @property string         $first_name
 * @property string         $last_name
 * @property string         $email
 * @property string         $city
 * @property string         $phone
 * @property string         $address_1
 * @property string         $address_2
 * @property string         $postal_code
 * @property string         $ntn_no
 * @property string         $gst_no
 * @property string         $provider_category
 * @property string         $provider_type
 * @property string         $bank_name
 * @property string         $account_number
 * @property string         $payment_mode
 * @property string         $balance_limit
 * @property string         $wht_rate
 * @property string         $excise_duty_rate
 * @property string         $special_discount_rate
 * @property string         $regular_discount_rate
 * @property string         $primary_contact_name
 * @property string         $primary_contact_phone
 * @property string         $primary_contact_email
 * @property string         $primary_contact_nic
 * @property string         $secondary_contact_name
 * @property string         $secondary_contact_phone
 * @property string         $secondary_contact_email
 * @property string         $secondary_contact_nic
 * @property string         $description
 * @property float          $amount_paid
 * @property \Carbon\Carbon $updated_at
 */
class Provider extends NsModel
{
    use HasFactory, NsDependable;

    protected $table = 'nexopos_' . 'providers';

    protected $guarded = [];

    protected $isDependencyFor = [
        Procurement::class => [
            'local_name' => 'name',
            'local_index' => 'id',
            'foreign_name' => 'code',
            'foreign_index' => 'provider_id',
        ],
    ];

    public function procurements()
    {
        return $this->hasMany(Procurement::class);
    }
    public function scopeActive($query)
    {
        return $query->where('active', true);
    }
}
