<?php
namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\DashboardController;
use App\Services\ARYSaveGoldService;
use App\Services\Options;
use Illuminate\Http\Request;

class ARYSaveGoldController extends DashboardController
{

    public function __construct(
        private ARYSaveGoldService $aRYSaveGoldService,
        private Options $optionsService
    ) {
        //
    }

    public function Index()
    {
        return $this->aRYSaveGoldService->ARYSaveGoldConnection();
    }
    public function searchCustomer($cellNo)
    {
        return $this->aRYSaveGoldService->searchSaveGoldCustomer($cellNo);
    }
    public function createCustomer($cellNo)
    {
        return $this->aRYSaveGoldService->registerSaveGoldCustomer($cellNo);
    }
    public function createPurchase($cellNo)
    {
        $orderID = 'O' . rand(0, 4);
        return $this->aRYSaveGoldService->createSaveGoldPurchase($cellNo, $orderID);
    }
    public function getCachedToken()
    {
        return $this->aRYSaveGoldService->getCachedSaveGoldToken();
    }
    public function destroyCachedToken()
    {
        return $this->aRYSaveGoldService->purgeCachedSaveGoldToken();
    }
    public function invalidateCachedToken()
    {
        return $this->aRYSaveGoldService->invalidateCachedSaveGoldToken();
    }

}
