<?php

use App\Crud\ProviderCrud;
use App\Models\Provider;
use App\Services\Helper;

return [
    'label' => __('Procurement'),
    'fields' => [
        [
            'type' => 'text',
            'name' => 'invoice_reference',
            'value' => $procurement->invoice_reference ?? '',
            'label' => __('Invoice Number'),
            'description' => __('If the procurement has been issued outside of NexoPOS, please provide a unique reference.'),
        ],
        [
            'type' => 'date',
            'name' => 'delivery_time',
            'value' => $procurement->delivery_time ?? ns()->date->now()->format('Y-m-d'),
            'label' => __('Delivery Time'),
            'description' => __('If the procurement has to be delivered at a specific time, define the moment here.'),
        ],
        [
            'type' => 'date',
            'name' => 'invoice_date',
            'value' => $procurement->invoice_date ?? ns()->date->now()->format('Y-m-d'),
            'label' => __('Invoice Date'),
            'description' => __('If you would like to define a custom invoice date.'),
        ],
        [
            'type' => 'switch',
            'name' => 'automatic_approval',
            'value' => $procurement->automatic_approval ?? 1,
            'options' => Helper::kvToJsOptions([
                0 => __('No'),
                1 => __('Yes'),
            ]),
            'label' => __('Automatic Approval'),
            'description' => __('Determine if the procurement should be marked automatically as approved once the Delivery Time occurs.'),
        ],
        [
            'type' => 'select',
            'name' => 'delivery_status',
            'value' => $procurement->delivery_status ?? 'delivered',
            'validation' => 'required',
            'options' => Helper::kvToJsOptions([
                'pending' => __('Pending'),
                'delivered' => __('Delivered'),
            ]),
            'label' => __('Delivery Status'),
            'description' => __('Determine what is the actual value of the procurement. Once "Delivered" the status can\'t be changed, and the stock will be updated.'),
        ],
        [
            'type' => 'select',
            'name' => 'payment_status',
            'value' => $procurement->payment_status ?? 'paid',
            'validation' => 'required',
            'options' => Helper::kvToJsOptions([
                'unpaid' => __('Unpaid'),
                'paid' => __('Paid'),
            ]),
            'label' => __('Payment Status'),
            'description' => __('Determine what is the actual payment status of the procurement.'),
        ],
        [
            'type' => 'search-select',
            'name' => 'provider_id',
            'component' => 'nsCrudForm',
            'props' => ProviderCrud::getFormConfig(),
            'value' => $procurement->provider_id ?? '',
            'validation' => 'required',
            'options' => Helper::toJsOptions(Provider::get(), ['id', 'first_name']),
            'label' => __('Provider'),
            'description' => __('Determine what is the actual provider of the current procurement.'),
        ],
        // [
        //     'type' => 'select',
        //     'name' => 'location',
        //     'value' => $procurement->location ?? 'store',
        //     'validation' => 'required',
        //     'options' => Helper::kvToJsOptions([
        //         'warehouse' => __('Warehouse'),
        //         'store' => __('Store'),
        //     ]),
        //     'label' => __('Location'),
        //     'description' => __('Determine what is the location of store.'),
        // ],
        // [
        //     'type' => 'select',
        //     'name' => 'payment_term',
        //     'value' => $procurement->payment_term ?? '1',
        //     'validation' => 'required',
        //     'options' => Helper::kvToJsOptions([
        //         '1' => __('1'),
        //         '2' => __('2'),
        //         '3' => __('3'),
        //         '4' => __('4'),
        //         '5' => __('5'),
        //         '6' => __('6'),
        //         '7' => __('7'),
        //         '8' => __('8'),
        //         '9' => __('9'),
        //         '10' => __('10'),
        //         '11' => __('11'),
        //         '12' => __('12'),
        //         '13' => __('13'),
        //         '14' => __('14'),
        //         '15' => __('15'),
        //         '16' => __('16'),
        //         '17' => __('17'),
        //         '18' => __('18'),
        //         '19' => __('19'),
        //         '20' => __('20'),
        //         '21' => __('21'),
        //         '22' => __('22'),
        //         '23' => __('23'),
        //         '24' => __('24'),
        //         '25' => __('25'),
        //         '26' => __('26'),
        //         '27' => __('27'),
        //         '28' => __('28'),
        //         '29' => __('29'),
        //         '30' => __('30'),

        //     ]),
        //     'label' => __('Day(s) of Payment Term'),
        //     'description' => __('Determine no. of days of payment term of the procurement.'),
        // ],
        // [
        //     'type' => 'select',
        //     'name' => 'payment_mode',
        //     'value' => $procurement->payment_mode ?? 'cash',
        //     'validation' => 'required',
        //     'options' => Helper::kvToJsOptions([
        //         'cheque' => __('Cheque'),
        //         'cash' => __('Cash'),
        //     ]),
        //     'label' => __('Payment Mode'),
        //     'description' => __('Determine what is the payment mode of the procurement.'),
        // ],
        // [
        //     'type' => 'textarea',
        //     'name' => 'remarks',
        //     'value' => $procurement->remarks ?? '',
        //     'label' => __('Remarks'),
        //     'description' => __('A brief remarks about what this procurement is about.'),
        // ],
    ],
];
